/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ScreenBase;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.EditorCategoryNodeConverter;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.EditorSettingsNode;

public abstract class GuiCategoryEditor<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    protected ED cutCategory;
    protected ED cutCategorySuper;

    protected GuiCategoryEditor(IXaeroMinimap modMain, Screen parent, Screen escape, Component title, EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
        super(modMain, parent, escape, title);
        this.dataConverter = dataConverter;
        this.editorData = this.constructEditorData(dataConverter);
    }

    protected abstract ED constructEditorData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.xaero_category_settings_cancel"), b -> this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
            if (result) {
                super.onExit(this.parent);
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, (Component)Component.translatable((String)"gui.xaero_category_settings_cancel_confirm"), (Component)Component.literal((String)"")))).bounds(this.width / 2 + 5, this.height - 32, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.xaero_category_settings_confirm"), b -> this.confirm()).bounds(this.width / 2 - 155, this.height - 32, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.xaero_category_settings_reset"), b -> this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.editorData = this.constructDefaultData(this.dataConverter);
            }
            this.minecraft.setScreen((Screen)this);
        }, (Component)Component.translatable((String)"gui.xaero_category_settings_reset_confirm1"), (Component)Component.translatable((String)"gui.xaero_category_settings_reset_confirm2")))).bounds(6, 6, 120, 20).build());
        this.rowList = new SettingRowList(this.dataConverter);
        this.addWidget(this.rowList);
    }

    private void confirm() {
        this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        super.onExit(this.parent);
    }

    @Override
    protected void onExit(Screen screen) {
        this.minecraft.setScreen((Screen)new ConfirmScreen(this, result -> {
            if (result) {
                this.confirm();
            }
            super.onExit(screen);
        }, (Component)Component.translatable((String)"gui.xaero_category_settings_save_confirm"), (Component)Component.literal((String)"")){

            public boolean keyPressed(int i, int j, int k) {
                if (i == 256) {
                    return true;
                }
                return super.keyPressed(i, j, k);
            }
        });
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderBackground(guiGraphics, i, j, f);
        this.rowList.render(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.minecraft.font, this.title, this.width / 2, 5, 0xFFFFFF);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        PoseStack poseStack = guiGraphics.pose();
        super.render(guiGraphics, i, j, f);
        if (this.rowList.hovered == null) {
            return;
        }
        Supplier<CursorBox> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
        if (tooltipSupplier == null) {
            return;
        }
        CursorBox tooltip = tooltipSupplier.get();
        if (tooltip == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.1);
        tooltip.drawBox(guiGraphics, i, j, this.width, this.height);
        poseStack.popPose();
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.rowList.isFocused() && i == 257 && this.rowList.confirmSelection()) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void tick() {
        this.rowList.tick();
        super.tick();
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    @Override
    public boolean mouseClicked(double d, double e, int i) {
        if (super.mouseClicked(d, e, i)) {
            return true;
        }
        return this.rowList.mouseClicked(d, e, i);
    }

    @Override
    public boolean mouseReleased(double d, double e, int i) {
        if (super.mouseReleased(d, e, i)) {
            return true;
        }
        return this.rowList.mouseReleased(d, e, i);
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (super.mouseDragged(d, e, i, f, g)) {
            return true;
        }
        return this.rowList.mouseDragged(d, e, i, f, g);
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        return this.rowList.mouseScrolled(d, e, f, g);
    }

    public class SettingRowList
    extends ObjectSelectionList<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
        private EditorNode lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private EditorListEntry hovered;
        private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
        private static final Component USAGE_NARRATION = Component.translatable((String)"narration.selection.usage");
        private static final Component LEFT_RIGHT_USAGE = Component.translatable((String)"narration.xaero_ui_list_left_right_usage");

        public SettingRowList(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategoryEditor.this.minecraft, GuiCategoryEditor.this.width, Math.max(4, GuiCategoryEditor.this.height - 48 - 32), 32, 24);
            this.dataConverter = dataConverter;
            this.updateEntries();
        }

        protected boolean isSelectedItem(int i) {
            return false;
        }

        public boolean hasCut() {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return false;
            }
            if (((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().contains(GuiCategoryEditor.this.cutCategory)) {
                return true;
            }
            this.setCutCategory(null, null);
            return false;
        }

        public ED getCut() {
            return GuiCategoryEditor.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategoryEditor.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategoryEditor.this.cutCategory = cutCategory;
            GuiCategoryEditor.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return;
            }
            if (destination == GuiCategoryEditor.this.cutCategory || destination == GuiCategoryEditor.this.cutCategorySuper) {
                this.setCutCategory(null, null);
                this.updateEntries();
                return;
            }
            ((EditorNode)destination).getExpandAction(this).run();
            this.setLastExpandedData((EditorNode)GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().remove(GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)destination).getSubCategories().add(0, GuiCategoryEditor.this.cutCategory);
            this.setCutCategory(null, null);
        }

        public boolean isFocused() {
            return GuiCategoryEditor.this.getFocused() == this;
        }

        public void setLastExpandedData(EditorNode lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        public void updateEntries() {
            double scrollBackup = this.getScrollAmount();
            this.clearEntries();
            ((EditorNode)GuiCategoryEditor.this.editorData).setExpanded(true);
            this.addEntriesForExpanded((EditorNode)GuiCategoryEditor.this.editorData, null);
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
            if (this.restoreScrollAfterUpdate) {
                this.setScrollAmount(scrollBackup);
                this.restoreScrollAfterUpdate = false;
            }
        }

        private void addEntriesForExpanded(EditorNode data, EditorNode parent) {
            int nextIndex = this.children().size();
            List<EditorNode> subExpandables = data.getSubNodes();
            if (subExpandables == null) {
                return;
            }
            EditorNode expandedData = null;
            for (EditorNode sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            EditorListRootEntry wrappedEntry = data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.width, expandedData == null);
            Entry currentEntry = new Entry(wrappedEntry, nextIndex++);
            this.addEntry((AbstractSelectionList.Entry)currentEntry);
            if (data == this.lastExpandedData) {
                this.setFocused((GuiEventListener)currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpanded(expandedData, data);
                return;
            }
            if (this.lastExpandedData == null && data.isExpanded()) {
                this.setFocused((GuiEventListener)currentEntry);
            }
            boolean first = true;
            for (EditorNode sed : subExpandables) {
                wrappedEntry = sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.width, false);
                Entry leafEntry = new Entry(wrappedEntry, nextIndex++);
                this.addEntry((AbstractSelectionList.Entry)leafEntry);
                if (sed == this.lastExpandedData) {
                    this.setFocused((GuiEventListener)leafEntry);
                }
                first = false;
            }
        }

        public boolean mouseClicked(double d, double e, int i) {
            if (!this.isMouseOver(d, e)) {
                this.setFocused(null);
            }
            return super.mouseClicked(d, e, i);
        }

        public void mouseMoved(double d, double e) {
            if (this.getSelected() != null) {
                ((Entry)this.getSelected()).mouseMoved(d, e);
            }
            super.mouseMoved(d, e);
        }

        public boolean keyReleased(int i, int j, int k) {
            if (this.getSelected() != null && ((Entry)this.getSelected()).keyReleased(i, j, k)) {
                return true;
            }
            return super.keyReleased(i, j, k);
        }

        public boolean charTyped(char c, int i) {
            boolean result;
            if (this.getSelected() != null && (result = ((Entry)this.getSelected()).charTyped(c, i))) {
                return true;
            }
            return super.charTyped(c, i);
        }

        public void tick() {
            if (this.getSelected() != null) {
                ((Entry)this.getSelected()).tick();
            }
        }

        public boolean confirmSelection() {
            Entry entry = (Entry)this.getSelected();
            if (entry == null) {
                return false;
            }
            EditorListEntry selectedSubEntry = entry.wrappedEntry.confirmSelection();
            return selectedSubEntry != null;
        }

        public void setFocused(GuiEventListener guiEventListener) {
            Entry entry;
            if (!this.children().contains(guiEventListener) || this.getFocused() == guiEventListener) {
                return;
            }
            if (this.getSelected() != null) {
                ((Entry)this.getSelected()).wrappedEntry.unfocusRecursively();
            }
            if (this.getFocused() != null) {
                ((Entry)this.getFocused()).setFocused(false);
            }
            if ((entry = (Entry)guiEventListener) != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            super.setFocused(guiEventListener);
            if (guiEventListener == null) {
                this.setSelected((Entry)null);
            }
            this.narrateSelection();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
        }

        public int getRowWidth() {
            return this.width;
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 164;
        }

        public void narrateSelection() {
            GuiCategoryEditor.this.afterKeyboardAction();
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            super.updateWidgetNarration(narrationElementOutput);
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, new Component[]{USAGE_NARRATION, LEFT_RIGHT_USAGE});
            }
        }

        public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            this.hovered = null;
            super.renderWidget(guiGraphics, i, j, f);
        }

        public EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry
        extends ObjectSelectionList.Entry<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
            private EditorListRootEntry wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(EditorListRootEntry entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                PoseStack poseStack = guiGraphics.pose();
                this.lastX = x;
                this.lastY = y;
                poseStack.pushPose();
                poseStack.translate((float)x, (float)y, 0.0f);
                boolean includesSelected = SettingRowList.this.getSelected() == this;
                this.wrappedEntry.preRender(guiGraphics, includesSelected, true);
                EditorListEntry hoveredInRow = this.wrappedEntry.render(guiGraphics, index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategoryEditor.this.font, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender(guiGraphics);
                poseStack.popPose();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int i) {
                SettingRowList.this.setFocused((GuiEventListener)this);
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
                return true;
            }

            public boolean mouseReleased(double mouseX, double mouseY, int i) {
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
                return super.mouseReleased(mouseX, mouseY, i);
            }

            public boolean mouseScrolled(double mouseX, double mouseY, double f, double g) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseScrolled(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), f, g)) {
                    return true;
                }
                return super.mouseScrolled(mouseX, mouseY, f, g);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int i, double f, double g) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseDragged(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), i, f, g)) {
                    return true;
                }
                return super.mouseDragged(mouseX, mouseY, i, f, g);
            }

            public boolean keyPressed(int i, int j, int k) {
                if (this.wrappedEntry.keyPressed(i, j, k, true)) {
                    return true;
                }
                return super.keyPressed(i, j, k);
            }

            public boolean keyReleased(int i, int j, int k) {
                if (this.wrappedEntry.keyReleased(i, j, k)) {
                    return true;
                }
                return super.keyReleased(i, j, k);
            }

            public boolean charTyped(char c, int i) {
                if (this.wrappedEntry.charTyped(c, i)) {
                    return true;
                }
                return super.charTyped(c, i);
            }

            public void setFocused(boolean bl) {
                this.wrappedEntry.setFocused(bl);
                super.setFocused(bl);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }

            public Component getNarration() {
                String selectedNarrationString = this.wrappedEntry.getSubNarration();
                if (selectedNarrationString == null) {
                    return Component.literal((String)"");
                }
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{selectedNarrationString});
            }
        }
    }
}

