/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message.tracker;

import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.common.XaeroMinimapSession;
import xaero.common.message.MinimapMessage;
import xaero.common.message.client.ClientMessageConsumer;

public class ClientboundTrackedPlayerPacket
extends MinimapMessage<ClientboundTrackedPlayerPacket> {
    private final boolean remove;
    private final UUID id;
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation dimension;

    public ClientboundTrackedPlayerPacket(boolean remove, UUID id, double x, double y, double z, ResourceLocation dimension) {
        this.remove = remove;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public void write(FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("r", this.remove);
        nbt.putUUID("i", this.id);
        if (!this.remove) {
            nbt.putDouble("x", this.x);
            nbt.putDouble("y", this.y);
            nbt.putDouble("z", this.z);
            nbt.putString("d", this.dimension.toString());
        }
        buffer.writeNbt((Tag)nbt);
    }

    public static ClientboundTrackedPlayerPacket read(FriendlyByteBuf buffer) {
        CompoundTag nbt = (CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap());
        boolean remove = nbt.getBoolean("r");
        UUID id = nbt.getUUID("i");
        double x = remove ? 0.0 : nbt.getDouble("x");
        double y = remove ? 0.0 : nbt.getDouble("y");
        double z = remove ? 0.0 : nbt.getDouble("z");
        String dimensionString = remove ? null : nbt.getString("d");
        ResourceLocation dimension = dimensionString == null ? null : ResourceLocation.parse((String)dimensionString);
        return new ClientboundTrackedPlayerPacket(remove, id, x, y, z, dimension);
    }

    public static class Handler
    implements ClientMessageConsumer<ClientboundTrackedPlayerPacket> {
        @Override
        public void handle(ClientboundTrackedPlayerPacket t) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            if (t.remove) {
                minimapSession.getMinimapProcessor().getSyncedTrackedPlayerManager().remove(t.id);
                return;
            }
            minimapSession.getMinimapProcessor().getSyncedTrackedPlayerManager().update(t.id, t.x, t.y, t.z, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)t.dimension));
        }
    }
}

