/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message.basic;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.common.message.MinimapMessage;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;

public class ClientboundRulesPacket
extends MinimapMessage<ClientboundRulesPacket> {
    public final boolean allowCaveModeOnServer;
    public final boolean allowNetherCaveModeOnServer;
    public final boolean allowRadarOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer, boolean allowRadarOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
        this.allowRadarOnServer = allowRadarOnServer;
    }

    public void write(FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("cm", this.allowCaveModeOnServer);
        nbt.putBoolean("ncm", this.allowNetherCaveModeOnServer);
        nbt.putBoolean("r", this.allowRadarOnServer);
        u.writeNbt((Tag)nbt);
    }

    public static ClientboundRulesPacket read(FriendlyByteBuf buffer) {
        CompoundTag nbt = buffer.readNbt();
        return new ClientboundRulesPacket(nbt.getBoolean("cm"), nbt.getBoolean("ncm"), nbt.getBoolean("r"));
    }

    public static class ClientHandler
    implements ClientMessageConsumer<ClientboundRulesPacket> {
        @Override
        public void handle(ClientboundRulesPacket message) {
            MinimapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

