/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.color.ColorRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.JsonHexadecimalInt;
import com.misterpemodder.shulkerboxtooltip.impl.config.SerializationException;
import com.misterpemodder.shulkerboxtooltip.impl.util.EnvironmentUtil;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import com.misterpemodder.shulkerboxtooltip.shadowed.blue.endless.jankson.Jankson;
import com.misterpemodder.shulkerboxtooltip.shadowed.blue.endless.jankson.JsonElement;
import com.misterpemodder.shulkerboxtooltip.shadowed.blue.endless.jankson.JsonObject;
import com.misterpemodder.shulkerboxtooltip.shadowed.blue.endless.jankson.JsonPrimitive;
import com.misterpemodder.shulkerboxtooltip.shadowed.blue.endless.jankson.api.Marshaller;
import com.misterpemodder.shulkerboxtooltip.shadowed.blue.endless.jankson.api.SyntaxError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class ShulkerBoxTooltipConfigSerializer {
    private final Jankson jankson = this.buildJankson();
    private static final String CONFIG_FILE_NAME = "shulkerboxtooltip.json5";

    private Jankson buildJankson() {
        Jankson.Builder builder = Jankson.builder();
        if (EnvironmentUtil.isClient()) {
            ClientOnly.buildJankson(builder);
        }
        return builder.build();
    }

    public void serialize(Configuration config) throws SerializationException {
        Path configPath = this.getConfigPath();
        ShulkerBoxTooltip.LOGGER.debug("Saving configuration to " + String.valueOf(configPath));
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (EnvironmentUtil.isClient() && !PluginManager.areColorsLoaded()) {
            ShulkerBoxTooltip.LOGGER.debug("Configuration is not fully loaded, not saving");
            return;
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            writer.write(this.jankson.toJson(config).toJson(true, true));
            writer.close();
            ShulkerBoxTooltip.LOGGER.debug("Configuration saved successfully");
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public Configuration deserialize() throws SerializationException {
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                JsonObject obj = this.jankson.load(configPath.toFile());
                Configuration config = this.jankson.fromJson(obj, EnvironmentUtil.getInstance().getConfigurationClass());
                if (config == null) {
                    throw new SerializationException("Failed to deserialize configuration");
                }
                return config;
            }
            catch (SyntaxError | IOException e) {
                throw new SerializationException(e);
            }
        }
        ShulkerBoxTooltip.LOGGER.info("Could not find configuration file, creating default file");
        return EnvironmentUtil.getInstance().makeConfiguration();
    }

    private Path getConfigPath() {
        return ShulkerBoxTooltip.getConfigDir().resolve(CONFIG_FILE_NAME);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class ClientOnly {
        private ClientOnly() {
        }

        private static void buildJankson(Jankson.Builder builder) {
            builder.registerDeserializer(String.class, Key.class, (str, marshaller) -> Key.fromTranslationKey(str));
            builder.registerDeserializer(JsonObject.class, Key.class, (obj, marshaller) -> Key.fromTranslationKey(obj.get(String.class, "code")));
            builder.registerSerializer(Key.class, (key, marshaller) -> {
                JsonObject object = new JsonObject();
                object.put("code", new JsonPrimitive(key.get().getName()));
                return object;
            });
            builder.registerDeserializer(JsonObject.class, ColorRegistry.class, ClientOnly::deserializeColorRegistry);
            builder.registerSerializer(ColorRegistry.class, ClientOnly::serializeColorRegistry);
        }

        private static ColorRegistry deserializeColorRegistry(JsonObject obj, Marshaller marshaller) {
            for (Map.Entry<String, JsonElement> categoryEntry : obj.entrySet()) {
                JsonElement jsonElement;
                ResourceLocation categoryId = ResourceLocation.tryParse((String)categoryEntry.getKey());
                if (categoryId == null || !((jsonElement = categoryEntry.getValue()) instanceof JsonObject)) continue;
                JsonObject categoryObject = (JsonObject)jsonElement;
                ClientOnly.deserializeColorCategory(categoryId, categoryObject);
            }
            return ColorRegistryImpl.INSTANCE;
        }

        private static JsonObject serializeColorRegistry(ColorRegistry registry, Marshaller marshaller) {
            JsonObject object = new JsonObject();
            for (Map.Entry<ResourceLocation, ColorRegistry.Category> categoryEntry : registry.categories().entrySet()) {
                JsonObject categoryObject = new JsonObject();
                for (Map.Entry<String, ColorKey> keyEntry : categoryEntry.getValue().keys().entrySet()) {
                    categoryObject.put(keyEntry.getKey(), new JsonHexadecimalInt(keyEntry.getValue().rgb()));
                    categoryObject.setComment(keyEntry.getKey(), String.format("(default value: %#x)", keyEntry.getValue().defaultRgb()));
                }
                object.put(categoryEntry.getKey().toString(), categoryObject);
            }
            return object;
        }

        private static void deserializeColorCategory(ResourceLocation id, JsonObject object) {
            ColorRegistryImpl.Category category = ColorRegistryImpl.INSTANCE.category(id);
            for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                boolean isValidValue;
                JsonElement jsonElement = entry.getValue();
                if (!(jsonElement instanceof JsonPrimitive)) continue;
                JsonPrimitive value = (JsonPrimitive)jsonElement;
                ColorKey key = category.key(entry.getKey());
                long rgbValue = value.asLong(Long.MIN_VALUE);
                boolean bl = isValidValue = rgbValue >= Integer.MIN_VALUE && rgbValue <= Integer.MAX_VALUE;
                if (key != null) {
                    if (isValidValue) {
                        key.setRgb((int)rgbValue);
                        continue;
                    }
                    key.setRgb(key.defaultRgb());
                    continue;
                }
                if (!isValidValue) continue;
                category.setRgbKeyLater(entry.getKey(), (int)rgbValue);
            }
        }
    }
}

