/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_enchanting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_enchanting.EmiEnchanting;
import fzzyhmstrs.emi_enchanting.EnchantmentRecipe;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@EmiEntrypoint
public class EmiClientPlugin
implements EmiPlugin {
    private static final ResourceLocation ENCHANTING_ID = ResourceLocation.fromNamespaceAndPath((String)EmiEnchanting.MOD_ID, (String)"enchantments");
    public static final EmiRecipeCategory ENCHANTING_CATEGORY = new EmiRecipeCategory(ENCHANTING_ID, (EmiRenderable)EmiStack.of((ItemLike)Items.ENCHANTED_BOOK));

    public void register(EmiRegistry registry) {
        registry.addCategory(ENCHANTING_CATEGORY);
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            RegistryAccess manager = world.registryAccess();
            ArrayListMultimap enchantsMap = ArrayListMultimap.create();
            for (Holder enchantment : manager.registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap()) {
                for (int i = 1; i <= ((Enchantment)enchantment.value()).getMaxLevel(); ++i) {
                    enchantsMap.put((Object)enchantment, (Object)EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
                }
            }
            ImmutableMap enchantsMapAsMap = ImmutableMap.copyOf((Map)enchantsMap.asMap());
            for (Map.Entry entry : enchantsMapAsMap.entrySet()) {
                registry.addRecipe((EmiRecipe)new EnchantmentRecipe((Collection)entry.getValue(), (Level)world, (Holder<Enchantment>)((Holder)entry.getKey()), (Map<Holder<Enchantment>, Collection<ItemStack>>)enchantsMapAsMap));
            }
        }
    }
}

