/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.recipe.requirements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.oierbravo.mechanicals.register.MechanicalRecipeRequirementTypes;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;

public record BiomeRequirement(ResourceKey<Biome> biomeResourceKey) implements IRecipeRequirement
{
    public static String ID = "biome";
    public static MapCodec<BiomeRequirement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("value", null).forGetter(BiomeRequirement::biomeResourceKey)).apply((Applicative)builder, BiomeRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BiomeRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BIOME), BiomeRequirement::biomeResourceKey, BiomeRequirement::new);

    public static BiomeRequirement of(ResourceKey<Biome> key) {
        return new BiomeRequirement(key);
    }

    public static BiomeRequirement of(String id) {
        return BiomeRequirement.of(ResourceLocation.parse((String)id));
    }

    public static BiomeRequirement of(ResourceLocation resourceLocation) {
        return BiomeRequirement.of((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)resourceLocation));
    }

    @Override
    public boolean test(Level pLevel, BlockEntity pBlockEntity) {
        if (this.biomeResourceKey == null) {
            return true;
        }
        Holder blockEntityBiome = pLevel.getBiome(pBlockEntity.getBlockPos());
        if (pLevel.isClientSide()) {
            return false;
        }
        Optional requiredBiomeHolder = pLevel.getServer().registryAccess().registryOrThrow(Registries.BIOME).asLookup().get(this.biomeResourceKey);
        return requiredBiomeHolder.isPresent() && blockEntityBiome.is(((Holder.Reference)requiredBiomeHolder.get()).key());
    }

    @Override
    public RecipeRequirementType<?> getType() {
        return MechanicalRecipeRequirementTypes.BIOME.get();
    }

    @Override
    public String getIdString() {
        return ID;
    }

    @Override
    public String toString() {
        return this.biomeResourceKey.location().toString();
    }
}

