/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public abstract class MovingStorageOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount = 0;
    private double maxInteractionRange = 0.0;
    private long nextOpenRecheck;

    protected abstract void onOpen();

    protected abstract void onClose();

    protected abstract boolean isOwnContainer(Player var1);

    public void incrementOpeners(Player player, Entity entity) {
        int i;
        if ((i = this.openCount++) == 0) {
            this.onOpen();
            player.level().gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, entity.blockPosition());
            this.nextOpenRecheck = player.level().getGameTime() + 5L;
        }
        this.maxInteractionRange = Math.max(player.blockInteractionRange(), this.maxInteractionRange);
    }

    public void decrementOpeners(Player player, Entity entity) {
        --this.openCount;
        if (this.openCount == 0) {
            this.onClose();
            player.level().gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_CLOSE, entity.blockPosition());
            this.maxInteractionRange = 0.0;
        }
    }

    private List<Player> getPlayersWithContainerOpen(Level level, BlockPos pos) {
        double maxDistance = this.maxInteractionRange + 4.0;
        AABB aabb = new AABB(pos).inflate(maxDistance);
        return level.getEntities(EntityTypeTest.forClass(Player.class), aabb, this::isOwnContainer);
    }

    public void tick(Level level, Entity entity) {
        if (level.getGameTime() > this.nextOpenRecheck && (level.getGameTime() - this.nextOpenRecheck < 15L || this.openCount > 0)) {
            this.recheckOpeners(entity);
        }
    }

    public void recheckOpeners(Entity entity) {
        Level level = entity.level();
        List<Player> playersWithStorageOpen = this.getPlayersWithContainerOpen(level, entity.blockPosition());
        this.maxInteractionRange = 0.0;
        for (Player player : playersWithStorageOpen) {
            this.maxInteractionRange = Math.max(player.blockInteractionRange(), this.maxInteractionRange);
        }
        int numberOfPlayers = playersWithStorageOpen.size();
        if (this.openCount != numberOfPlayers) {
            if (numberOfPlayers != 0 && this.openCount == 0) {
                this.onOpen();
                level.gameEvent(null, (Holder)GameEvent.CONTAINER_OPEN, entity.blockPosition());
            } else if (numberOfPlayers == 0) {
                this.onClose();
                level.gameEvent(null, (Holder)GameEvent.CONTAINER_CLOSE, entity.blockPosition());
            }
            this.openCount = numberOfPlayers;
        }
        if (numberOfPlayers > 0) {
            this.nextOpenRecheck = level.getGameTime() + 5L;
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }
}

