/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.biome;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.regions_unexplored.world.level.biome.DefaultBiomes;
import net.regions_unexplored.world.level.biome.VanillaFallbackBiome;

public class RegionPrimaryBiomeBuilder {
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.span((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES = DefaultBiomes.getPrimaryMiddleBiome();
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = DefaultBiomes.getPrimaryMiddleBiomeVariant();
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES = DefaultBiomes.getPrimaryPlateauBiome();
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = DefaultBiomes.getPrimaryPlateauBiomeVariant();
    private final ResourceKey<Biome>[][] SHATTERED_BIOMES = DefaultBiomes.getPrimaryShatteredBiome();
    private final ResourceKey<Biome>[][] RIVER_BIOMES = DefaultBiomes.getPrimaryRiverBiome();
    private final ResourceKey<Biome>[][] RIVER_BIOMES_VARIANT = DefaultBiomes.getPrimaryRiverBiomeVariant();
    private final ResourceKey<Biome>[][] SWAMP_BIOMES = DefaultBiomes.getPrimarySwampBiome();
    private final ResourceKey<Biome>[][] OCEANS = DefaultBiomes.getPrimaryOceanBiome();

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addOffCoastBiomes(builder);
        this.addInlandBiomes(builder);
        this.addUndergroundBiomes(builder);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addSurfaceBiome(builder, this.temperatures[0], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryIslandBiome(0)) ? DefaultBiomes.getPrimaryIslandBiome(0) : Biomes.MUSHROOM_FIELDS);
        this.addSurfaceBiome(builder, this.temperatures[1], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryIslandBiome(1)) ? DefaultBiomes.getPrimaryIslandBiome(1) : Biomes.MUSHROOM_FIELDS);
        this.addSurfaceBiome(builder, this.temperatures[2], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryIslandBiome(2)) ? DefaultBiomes.getPrimaryIslandBiome(2) : Biomes.MUSHROOM_FIELDS);
        this.addSurfaceBiome(builder, this.temperatures[3], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryIslandBiome(3)) ? DefaultBiomes.getPrimaryIslandBiome(3) : Biomes.MUSHROOM_FIELDS);
        this.addSurfaceBiome(builder, this.temperatures[4], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryIslandBiome(4)) ? DefaultBiomes.getPrimaryIslandBiome(4) : Biomes.MUSHROOM_FIELDS);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(this.OCEANS[0][i]) ? this.OCEANS[0][i] : VanillaFallbackBiome.VANILLA_OCEANS[0][i]);
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(this.OCEANS[1][i]) ? this.OCEANS[1][i] : VanillaFallbackBiome.VANILLA_OCEANS[0][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addMidSlice(builder, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(builder, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(builder, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(builder, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(builder, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(builder, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(builder, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(builder, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(builder, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(builder, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(builder, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(builder, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(builder, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, shatteredBiome);
                ResourceKey<Biome> peakBiomes = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey<Biome> peakBiome = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey<Biome> stoneBeachCold = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryStoneShoreBiome(true)) ? DefaultBiomes.getPrimaryStoneShoreBiome(true) : Biomes.STONY_SHORE;
        ResourceKey<Biome> stoneBeachHot = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryStoneShoreBiome(false)) ? DefaultBiomes.getPrimaryStoneShoreBiome(false) : Biomes.STONY_SHORE;
        this.addSurfaceBiome(builder, Climate.Parameter.span((Climate.Parameter)this.temperatures[0], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachCold);
        this.addSurfaceBiome(builder, Climate.Parameter.span((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachHot);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> swampBiome = this.pickSwampBiome(i, j);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(i);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiome : plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiome);
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                } else {
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                    continue;
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey<Biome> stoneBeachCold = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryStoneShoreBiome(true)) ? DefaultBiomes.getPrimaryStoneShoreBiome(true) : Biomes.STONY_SHORE;
        ResourceKey<Biome> stoneBeachHot = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryStoneShoreBiome(false)) ? DefaultBiomes.getPrimaryStoneShoreBiome(false) : Biomes.STONY_SHORE;
        this.addSurfaceBiome(builder, Climate.Parameter.span((Climate.Parameter)this.temperatures[0], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachCold);
        this.addSurfaceBiome(builder, Climate.Parameter.span((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachHot);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> swampBiome = this.pickSwampBiome(i, j);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(i);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey<Biome> stoneBeachCold = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryStoneShoreBiome(true)) ? DefaultBiomes.getPrimaryStoneShoreBiome(true) : Biomes.STONY_SHORE;
        ResourceKey<Biome> stoneBeachHot = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryStoneShoreBiome(false)) ? DefaultBiomes.getPrimaryStoneShoreBiome(false) : Biomes.STONY_SHORE;
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> swampBiome = this.pickSwampBiome(i, j);
                ResourceKey<Biome> riverBiome = this.pickRiverBiome(i, j, weirdness);
                ResourceKey<Biome> cliffBiome = (float)this.temperatures[i].max() <= -0.45f ? stoneBeachCold : stoneBeachHot;
                ResourceKey<Biome> maybePickCliff = weirdness.max() < 0L ? cliffBiome : riverBiome;
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, maybePickCliff);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiome);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)-0.9f), this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(2)) ? DefaultBiomes.getPrimaryCaveBiome(2) : Biomes.LUSH_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)-0.9f), this.FULL_RANGE, Climate.Parameter.span((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(7)) ? DefaultBiomes.getPrimaryCaveBiome(7) : Biomes.DRIPSTONE_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)0.94f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(6)) ? DefaultBiomes.getPrimaryCaveBiome(6) : Biomes.DRIPSTONE_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)0.9f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.span((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(7)) ? DefaultBiomes.getPrimaryCaveBiome(7) : Biomes.DRIPSTONE_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)-0.8f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(1)) ? DefaultBiomes.getPrimaryCaveBiome(1) : Biomes.LUSH_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)-0.8f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(5)) ? DefaultBiomes.getPrimaryCaveBiome(5) : Biomes.LUSH_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.span((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(4)) ? DefaultBiomes.getPrimaryCaveBiome(4) : Biomes.LUSH_CAVES);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.span((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(5)) ? DefaultBiomes.getPrimaryCaveBiome(5) : Biomes.LUSH_CAVES);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(3)) ? DefaultBiomes.getPrimaryCaveBiome(3) : Biomes.DEEP_DARK);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryCaveBiome(8)) ? DefaultBiomes.getPrimaryCaveBiome(8) : Biomes.DEEP_DARK);
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            if (DefaultBiomes.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (this.MIDDLE_BIOMES_VARIANT[temperature][humidity] == null) {
            if (DefaultBiomes.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (DefaultBiomes.isBiomeEnabled(this.MIDDLE_BIOMES_VARIANT[temperature][humidity])) {
            return this.MIDDLE_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickMiddleBiomeOrSlopeIfCold(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> maybePickToweringCliffsBiome(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> fallbackBiome) {
        ResourceKey resourceKey = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryShatteredCliffBiome()) ? DefaultBiomes.getPrimaryShatteredCliffBiome() : Biomes.WINDSWEPT_SAVANNA;
        return temperature > 1 && humidity < 4 && weirdness.max() >= 0L ? resourceKey : fallbackBiome;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourceKey = weirdness.max() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature);
        return this.maybePickToweringCliffsBiome(temperature, humidity, weirdness, resourceKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature) {
        if (temperature == 0) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryBeachBiome(temperature)) ? DefaultBiomes.getPrimaryBeachBiome(temperature) : Biomes.SNOWY_BEACH;
        }
        if (temperature == 1) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryBeachBiome(temperature)) ? DefaultBiomes.getPrimaryBeachBiome(temperature) : Biomes.BEACH;
        }
        if (temperature == 2) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryBeachBiome(temperature)) ? DefaultBiomes.getPrimaryBeachBiome(temperature) : Biomes.BEACH;
        }
        if (temperature == 3) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryBeachBiome(temperature)) ? DefaultBiomes.getPrimaryBeachBiome(temperature) : Biomes.BEACH;
        }
        return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryBeachBiome(temperature)) ? DefaultBiomes.getPrimaryBeachBiome(temperature) : Biomes.BEACH;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            if (DefaultBiomes.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (this.PLATEAU_BIOMES_VARIANT[temperature][humidity] == null) {
            if (DefaultBiomes.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (DefaultBiomes.isBiomeEnabled(this.PLATEAU_BIOMES_VARIANT[temperature][humidity])) {
            return this.PLATEAU_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiome(temperature)) ? DefaultBiomes.getPrimaryPeakBiome(temperature) : Biomes.JAGGED_PEAKS;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getPrimaryPeakBiomeVariant(temperature) : Biomes.FROZEN_PEAKS;
        }
        if (temperature == 1) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiome(temperature)) ? DefaultBiomes.getPrimaryPeakBiome(temperature) : Biomes.JAGGED_PEAKS;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getPrimaryPeakBiomeVariant(temperature) : Biomes.FROZEN_PEAKS;
        }
        if (temperature == 2) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiome(temperature)) ? DefaultBiomes.getPrimaryPeakBiome(temperature) : Biomes.JAGGED_PEAKS;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getPrimaryPeakBiomeVariant(temperature) : Biomes.FROZEN_PEAKS;
        }
        if (temperature == 3) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiome(temperature)) ? DefaultBiomes.getPrimaryPeakBiome(temperature) : Biomes.STONY_PEAKS;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getPrimaryPeakBiomeVariant(temperature) : Biomes.STONY_PEAKS;
        }
        if (weirdness.max() < 0L) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiome(temperature)) ? DefaultBiomes.getPrimaryPeakBiome(temperature) : Biomes.BADLANDS;
        }
        return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getPrimaryPeakBiomeVariant(temperature) : Biomes.WOODED_BADLANDS;
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiome(temperature)) ? DefaultBiomes.getPrimarySlopeBiome(temperature) : Biomes.SNOWY_SLOPES;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getPrimarySlopeBiomeVariant(temperature) : Biomes.GROVE;
        }
        if (temperature == 1) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiome(temperature)) ? DefaultBiomes.getPrimarySlopeBiome(temperature) : Biomes.GROVE;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getPrimarySlopeBiomeVariant(temperature) : Biomes.SNOWY_SLOPES;
        }
        if (temperature == 2) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiome(temperature)) ? DefaultBiomes.getPrimarySlopeBiome(temperature) : Biomes.GROVE;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getPrimarySlopeBiomeVariant(temperature) : Biomes.SNOWY_SLOPES;
        }
        if (temperature == 3) {
            if (weirdness.max() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiome(temperature)) ? DefaultBiomes.getPrimarySlopeBiome(temperature) : Biomes.STONY_PEAKS;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getPrimarySlopeBiomeVariant(temperature) : Biomes.STONY_PEAKS;
        }
        if (weirdness.max() < 0L) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiome(temperature)) ? DefaultBiomes.getPrimarySlopeBiome(temperature) : Biomes.SAVANNA;
        }
        return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getPrimarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getPrimarySlopeBiomeVariant(temperature) : Biomes.SAVANNA;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourceKey = DefaultBiomes.isBiomeEnabled(this.SHATTERED_BIOMES[temperature][humidity]) ? this.SHATTERED_BIOMES[temperature][humidity] : VanillaFallbackBiome.VANILLA_SHATTERED_BIOMES[temperature][humidity];
        return resourceKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : resourceKey;
    }

    private ResourceKey<Biome> pickRiverBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            if (DefaultBiomes.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (this.RIVER_BIOMES_VARIANT[temperature][humidity] == null) {
            if (DefaultBiomes.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (DefaultBiomes.isBiomeEnabled(this.RIVER_BIOMES_VARIANT[temperature][humidity])) {
            return this.RIVER_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_RIVER_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickSwampBiome(int temperature, int humidity) {
        if (DefaultBiomes.isBiomeEnabled(this.SWAMP_BIOMES[temperature][humidity])) {
            return this.SWAMP_BIOMES[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_SWAMP_BIOMES[temperature][humidity];
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.span((float)0.24f, (float)0.9f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addBottomBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.1f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

