/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.entity.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.regions_unexplored.Constants;
import net.regions_unexplored.entity.custom.RuBoat;
import net.regions_unexplored.entity.custom.RuChestBoat;
import org.joml.Quaternionf;

public class RuBoatRenderer
extends BoatRenderer {
    private final Map<RuBoat.ModelType, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(RuBoat.ModelType.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)Constants.id(RuBoatRenderer.getTextureLocation(model, chest)), (Object)this.createBoatModel(context, (RuBoat.ModelType)((Object)model), chest))));

    public RuBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, false);
    }

    public void render(Boat entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float h;
        Pair<ResourceLocation, ListModel<Boat>> pair = null;
        if (entity instanceof RuBoat) {
            RuBoat entity1 = (RuBoat)entity;
            pair = this.boatResources.get((Object)entity1.getModel());
        } else if (entity instanceof RuChestBoat) {
            RuChestBoat entity2 = (RuChestBoat)entity;
            pair = this.boatResources.get((Object)entity2.getModel());
        }
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.375f, 0.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.getHurtTime() - partialTicks;
        float g = entity.getDamage() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * g / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(h = entity.getBubbleAngle(partialTicks)), (float)0.0f)) {
            matrixStack.mulPose(new Quaternionf().setAngleAxis(entity.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        ListModel listModel = (ListModel)pair.getSecond();
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        listModel.setupAnim((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.getBuffer(listModel.renderType(resourceLocation));
        listModel.renderToBuffer(matrixStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (!entity.isUnderWater()) {
            VertexConsumer vertexConsumer2 = buffer.getBuffer(RenderType.waterMask());
            if (listModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                waterPatchModel.waterPatch().render(matrixStack, vertexConsumer2, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        matrixStack.popPose();
    }

    private static String getTextureLocation(RuBoat.ModelType type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, RuBoat.ModelType type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? RuBoatRenderer.chestBoatTextureLocation(type) : RuBoatRenderer.boatTextureLocation(type);
        ModelPart baked = context.bakeLayer(modellayerlocation);
        return chest ? new ChestBoatModel(baked) : new BoatModel(baked);
    }

    private static ModelLayerLocation getModel(String name, String model) {
        return new ModelLayerLocation(Constants.id(name), model);
    }

    public static ModelLayerLocation boatTextureLocation(RuBoat.ModelType type) {
        return RuBoatRenderer.getModel("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation chestBoatTextureLocation(RuBoat.ModelType type) {
        return RuBoatRenderer.getModel("chest_boat/" + type.getName(), "main");
    }
}

