/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.capability.IStorageBlockItemHandler;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedStorageMenu
extends AbstractContainerMenu {
    private final IStorageBlockItemHandler itemHandler;
    private final int maxSlotChest;

    public static FramedStorageMenu createSingle(int windowId, Inventory inv, IStorageBlockItemHandler itemHandler) {
        return new FramedStorageMenu((MenuType)FBContent.MENU_TYPE_FRAMED_STORAGE.value(), windowId, inv, itemHandler);
    }

    public static FramedStorageMenu createDouble(int windowId, Inventory inv, IStorageBlockItemHandler itemHandler) {
        return new FramedStorageMenu((MenuType)FBContent.MENU_TYPE_FRAMED_DOUBLE_CHEST.value(), windowId, inv, itemHandler);
    }

    public static FramedStorageMenu createSingle(int windowId, Inventory inv) {
        return FramedStorageMenu.createSingle(windowId, inv, FramedStorageBlockEntity.createItemHandler(null, false));
    }

    public static FramedStorageMenu createDouble(int windowId, Inventory inv) {
        return FramedStorageMenu.createDouble(windowId, inv, FramedStorageBlockEntity.createItemHandler(null, true));
    }

    private FramedStorageMenu(MenuType<?> type, int windowId, Inventory inv, IStorageBlockItemHandler itemHandler) {
        super(type, windowId);
        this.itemHandler = itemHandler;
        this.maxSlotChest = itemHandler.getSlots();
        int rows = this.getRowCount();
        int y = 18;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, col + row * 9, 8 + col * 18, y));
            }
            y += 18;
        }
        FramedUtils.addPlayerInvSlots(x$0 -> this.addSlot((Slot)x$0), inv, 8, y + 13);
    }

    public int getRowCount() {
        return this.itemHandler.getSlots() / 9;
    }

    public boolean stillValid(Player player) {
        return this.itemHandler.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remainder = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            remainder = stack.copy();
            if (index < this.maxSlotChest ? !this.moveItemStackTo(stack, this.maxSlotChest, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, this.maxSlotChest, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return remainder;
    }

    public void removed(Player player) {
        super.removed(player);
        this.itemHandler.close();
    }
}

