/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class PyramidShapes
implements SplitShapeGenerator {
    public static final PyramidShapes FULL = new PyramidShapes(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.25, (double)0.25, (double)8.0, (double)15.75, (double)15.75, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.5, (double)12.0, (double)12.0, (double)8.0), Block.box((double)7.75, (double)7.75, (double)0.0, (double)8.25, (double)8.25, (double)0.5)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.25, (double)0.25, (double)8.0, (double)15.75, (double)15.75, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.5, (double)12.0, (double)12.0, (double)8.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)0.5)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.25, (double)0.25, (double)8.0, (double)15.75, (double)15.75, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0)));
    public static final PyramidShapes SLAB = new PyramidShapes(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)16.0), Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0)), null, null);
    public static final PyramidShapes UPPER_SLAB = new PyramidShapes(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.0), Block.box((double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)15.5, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.5, (double)12.0, (double)12.0, (double)4.0), Block.box((double)7.5, (double)7.5, (double)0.0, (double)8.5, (double)8.5, (double)0.5)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.0), Block.box((double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)15.5, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.5, (double)12.0, (double)12.0, (double)4.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)0.5)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.0), Block.box((double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)15.5, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)));
    public static final PyramidShapes ELEVATED_SLAB = new PyramidShapes(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)15.5, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.5, (double)12.0, (double)12.0, (double)4.0), Block.box((double)7.5, (double)7.5, (double)0.0, (double)8.5, (double)8.5, (double)0.5)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)15.5, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.5, (double)12.0, (double)12.0, (double)4.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)0.5)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)15.5, (double)8.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)));
    private final Supplier<VoxelShape> northShape;
    private final Supplier<VoxelShape> northOcclusionShape;
    @Nullable
    private final Supplier<VoxelShape> northOcclusionShapePost;
    @Nullable
    private final Supplier<VoxelShape> northOcclusionShapePillar;

    private PyramidShapes(Supplier<VoxelShape> northShape, Supplier<VoxelShape> northOcclusionShape, @Nullable Supplier<VoxelShape> northOcclusionShapePost, @Nullable Supplier<VoxelShape> northOcclusionShapePillar) {
        this.northShape = northShape;
        this.northOcclusionShape = northOcclusionShape;
        this.northOcclusionShapePost = northOcclusionShapePost;
        this.northOcclusionShapePillar = northOcclusionShapePillar;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return PyramidShapes.generate(states, this.northShape, null, null);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return PyramidShapes.generate(states, this.northOcclusionShape, this.northOcclusionShapePost, this.northOcclusionShapePillar);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, Supplier<VoxelShape> northShape, @Nullable Supplier<VoxelShape> northShapePost, @Nullable Supplier<VoxelShape> northShapePillar) {
        VoxelShape shapeNorth = northShape.get();
        VoxelShape shapeNorthPost = northShapePost != null ? northShapePost.get() : null;
        VoxelShape shapeNorthPillar = northShapePillar != null ? northShapePillar.get() : null;
        VoxelShape shapeUp = ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.UP, shapeNorth);
        VoxelShape[] upShapes = new VoxelShape[]{shapeUp, shapeNorthPost != null ? ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.UP, shapeNorthPost) : shapeUp, shapeNorthPillar != null ? ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.UP, shapeNorthPillar) : shapeUp};
        VoxelShape shapeDown = ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.DOWN, shapeNorth);
        VoxelShape[] downShapes = new VoxelShape[]{shapeDown, shapeNorthPost != null ? ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.DOWN, shapeNorthPost) : shapeDown, shapeNorthPillar != null ? ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.DOWN, shapeNorthPillar) : shapeDown};
        VoxelShape[] horShapesNone = ShapeUtils.makeHorizontalRotations(shapeNorth, Direction.NORTH);
        VoxelShape[][] horShapes = new VoxelShape[][]{horShapesNone, shapeNorthPost != null ? ShapeUtils.makeHorizontalRotations(shapeNorthPost, Direction.NORTH) : horShapesNone, shapeNorthPillar != null ? ShapeUtils.makeHorizontalRotations(shapeNorthPillar, Direction.NORTH) : horShapesNone};
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            int conIndex = Utils.tryGetValue(state, PropertyHolder.PILLAR_CONNECTION, PillarConnection.NONE).ordinal();
            VoxelShape shape = switch (facing) {
                case Direction.UP -> upShapes[conIndex];
                case Direction.DOWN -> downShapes[conIndex];
                default -> horShapes[conIndex][facing.get2DDataValue()];
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

