/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.stairs;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Triangle;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;

public class FramedSlicedSlopedStairsSlabBlockEntity
extends FramedDoubleBlockEntity {
    static final Triangle[] TRIANGLES = (Triangle[])Util.make((Object)new Triangle[4], arr -> {
        arr[Direction.NORTH.get2DDataValue()] = new Triangle(new Vec3(1.0, 0.5, 1.0), new Vec3(0.0, 0.5, 1.0), new Vec3(1.0, 0.5, 0.0));
        arr[Direction.SOUTH.get2DDataValue()] = new Triangle(new Vec3(0.0, 0.5, 0.0), new Vec3(1.0, 0.5, 0.0), new Vec3(0.0, 0.5, 1.0));
        arr[Direction.WEST.get2DDataValue()] = new Triangle(new Vec3(1.0, 0.5, 0.0), new Vec3(0.0, 0.5, 0.0), new Vec3(1.0, 0.5, 1.0));
        arr[Direction.EAST.get2DDataValue()] = new Triangle(new Vec3(0.0, 0.5, 1.0), new Vec3(1.0, 0.5, 1.0), new Vec3(0.0, 0.5, 0.0));
    });

    public FramedSlicedSlopedStairsSlabBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_SLICED_SLOPED_DOUBLE_STAIRS_SLAB.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Vec3 origin;
        Triangle tri;
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        Direction dirTwo = (Boolean)this.getBlockState().getValue((Property)FramedProperties.TOP) != false ? Direction.UP : Direction.DOWN;
        Direction side = hit.getDirection();
        Vec3 hitVec = hit.getLocation();
        if (side == dirTwo) {
            return false;
        }
        if (side == facing || side == facing.getCounterClockWise()) {
            return Utils.fractionInDir(hitVec, dirTwo) < 0.5;
        }
        if (side == facing.getOpposite() || side == facing.getClockWise()) {
            if (Utils.fractionInDir(hitVec, dirTwo) > 0.5) {
                return false;
            }
        } else if (side == dirTwo.getOpposite()) {
            double par = Utils.fractionInDir(hitVec, facing);
            double perp = Utils.fractionInDir(hitVec, facing.getClockWise());
            if (perp < par) {
                return true;
            }
        }
        return !(tri = TRIANGLES[facing.get2DDataValue()]).intersects(origin = eyePos.subtract((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()), lookVec.normalize());
    }
}

