/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedSpecialBlockItem;

public class FramedLayeredCubeBlock
extends FramedBlock {
    private static final Direction[] DIRECTIONS = Direction.values();

    public FramedLayeredCubeBlock() {
        super(BlockType.FRAMED_LAYERED_CUBE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.LAYERS, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, context).withTargetFacing(true)).withCustom((state, modCtx) -> {
            BlockState prevState = modCtx.getLevel().getBlockState(modCtx.getClickedPos());
            if (prevState.is((Block)this)) {
                int layers = (Integer)prevState.getValue((Property)BlockStateProperties.LAYERS);
                return (BlockState)prevState.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(Math.min(8, layers + 1)));
            }
            return state;
        })).withWater()).build();
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        int layers = (Integer)state.getValue((Property)BlockStateProperties.LAYERS);
        if (layers >= 8 || !useContext.getItemInHand().is(this.asItem())) {
            return false;
        }
        if (useContext.replacingClickedOnBlock()) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return useContext.getClickedFace() == facing;
        }
        return true;
    }

    @Override
    public BlockItem createBlockItem() {
        return new FramedSpecialBlockItem.Single(this, new Item.Properties()){

            @Override
            @Nullable
            protected BlockState getReplacementState(BlockPlaceContext ctx, BlockState originalState) {
                return FramedLayeredCubeBlock.this.getStateForPlacement(ctx);
            }
        };
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.LAND && (Integer)state.getValue((Property)BlockStateProperties.LAYERS) < 5;
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)(switch (rot) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> facing;
            case Rotation.CLOCKWISE_90 -> DIRECTIONS[(facing.ordinal() + 1) % DIRECTIONS.length];
            case Rotation.CLOCKWISE_180 -> facing.getOpposite();
            case Rotation.COUNTERCLOCKWISE_90 -> DIRECTIONS[Mth.positiveModulo((int)(facing.ordinal() - 1), (int)DIRECTIONS.length)];
        }));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (Utils.isY(facing)) {
            return state;
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate(facing));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.FACING, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }
}

