/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPillarGeometry
extends Geometry {
    private final Direction.Axis axis;
    private final float capStart;
    private final float capEnd;
    private final float sideCut;
    private final boolean useSolidBase;

    public FramedPillarGeometry(GeometryFactory.Context ctx) {
        this.axis = (Direction.Axis)ctx.state().getValue((Property)BlockStateProperties.AXIS);
        boolean post = ((IFramedBlock)ctx.state().getBlock()).getBlockType() == BlockType.FRAMED_POST;
        this.capStart = post ? 0.375f : 0.25f;
        this.sideCut = post ? 0.625f : 0.75f;
        this.capEnd = this.sideCut;
        this.useSolidBase = post;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        FramedPillarGeometry.createPillarQuad(quad, this.axis, this.capStart, this.capEnd, this.sideCut).export(quadMap.get((Direction)(quadDir.getAxis() == this.axis ? quadDir : null)));
    }

    public static QuadModifier createPillarQuad(BakedQuad quad, Direction.Axis axis, float capStart, float capEnd, float sideCut) {
        Direction quadDir = quad.getDirection();
        if (quadDir.getAxis() == axis) {
            if (axis == Direction.Axis.Y) {
                return QuadModifier.of(quad).apply(Modifiers.cutTopBottom(capStart, capStart, capEnd, capEnd));
            }
            return QuadModifier.of(quad).apply(Modifiers.cutSide(capStart, capStart, capEnd, capEnd));
        }
        if (axis == Direction.Axis.Y) {
            return QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getClockWise(), sideCut)).apply(Modifiers.cutSideLeftRight(quadDir.getCounterClockWise(), sideCut)).apply(Modifiers.setPosition(sideCut));
        }
        if (Utils.isY(quadDir)) {
            return QuadModifier.of(quad).apply(Modifiers.cutTopBottom(FramedPillarGeometry.axisToDir(axis, true).getClockWise(), sideCut)).apply(Modifiers.cutTopBottom(FramedPillarGeometry.axisToDir(axis, false).getClockWise(), sideCut)).apply(Modifiers.setPosition(sideCut));
        }
        return QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, sideCut)).apply(Modifiers.cutSideUpDown(false, sideCut)).apply(Modifiers.setPosition(sideCut));
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return this.useSolidBase;
    }

    private static Direction axisToDir(Direction.Axis axis, boolean positive) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (positive) {
                    yield Direction.EAST;
                }
                yield Direction.WEST;
            }
            case Direction.Axis.Y -> {
                if (positive) {
                    yield Direction.UP;
                }
                yield Direction.DOWN;
            }
            case Direction.Axis.Z -> positive ? Direction.SOUTH : Direction.NORTH;
        };
    }
}

