/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.door;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedDoorGeometry
extends Geometry {
    private static final TranslatedItemModelInfo ITEM_MODEL_INFO = TranslatedItemModelInfo.handOrGui(0.0f, 0.0f, -0.5f);
    private final Direction dir;
    private final boolean hingeRight;
    private final boolean open;
    private final boolean gate;

    public FramedDoorGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.hingeRight = ctx.state().getValue((Property)BlockStateProperties.DOOR_HINGE) == DoorHingeSide.RIGHT;
        this.open = (Boolean)ctx.state().getValue((Property)BlockStateProperties.OPEN);
        this.gate = ctx.state().is(FBContent.BLOCK_FRAMED_GATE) || ctx.state().is(FBContent.BLOCK_FRAMED_IRON_GATE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir;
        Direction faceDir = this.dir;
        if (this.open) {
            Direction direction = faceDir = this.hingeRight ? faceDir.getCounterClockWise() : faceDir.getClockWise();
        }
        if (Utils.isY(quadDir = quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(faceDir, 0.1875f)).export(quadMap.get(quadDir));
        } else if (quadDir == faceDir) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(faceDir, 0.1875f)).export(quadMap.get(quadDir));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return this.gate ? ITEM_MODEL_INFO : super.getItemModelInfo();
    }
}

