/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.util;

import com.divnectar.createblockchain.block.CurrencyMinerBlock;
import com.divnectar.createblockchain.block.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CapabilityRegistry {
    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlocks.CURRENCY_MINER_BE.get(), (blockEntity, context) -> {
            Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)CurrencyMinerBlock.FACING);
            if (context == facing.getClockWise() || context == facing.getCounterClockWise()) {
                return blockEntity.getEnergyStorage();
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlocks.CURRENCY_MINER_BE.get(), (blockEntity, context) -> {
            Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)CurrencyMinerBlock.FACING);
            if (context == facing.getOpposite()) {
                return new SidedItemHandler(blockEntity.getItemHandler(), 0, false, true);
            }
            if (context == facing) {
                return new SidedItemHandler(blockEntity.getItemHandler(), 1, true, false);
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlocks.CURRENCY_MINER_BE.get(), (blockEntity, context) -> {
            if (context == Direction.UP) {
                return blockEntity.getFluidTank();
            }
            return null;
        });
    }

    private static class SidedItemHandler
    implements IItemHandler {
        private final ItemStackHandler parent;
        private final int slotIndex;
        private final boolean canInsert;
        private final boolean canExtract;

        public SidedItemHandler(ItemStackHandler parent, int slotIndex, boolean canInsert, boolean canExtract) {
            this.parent = parent;
            this.slotIndex = slotIndex;
            this.canInsert = canInsert;
            this.canExtract = canExtract;
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return this.parent.getStackInSlot(this.slotIndex);
            }
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.canInsert || slot != 0) {
                return stack;
            }
            return this.parent.insertItem(this.slotIndex, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.canExtract || slot != 0) {
                return ItemStack.EMPTY;
            }
            return this.parent.extractItem(this.slotIndex, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return this.parent.getSlotLimit(this.slotIndex);
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return this.parent.isItemValid(this.slotIndex, stack);
            }
            return false;
        }
    }
}

