/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.datagen;

import com.divnectar.createblockchain.block.ModBlocks;
import com.divnectar.createblockchain.item.ModItems;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModBlockLootTables
extends BlockLootSubProvider {
    public ModBlockLootTables(HolderLookup.Provider provider) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.add((Block)ModBlocks.MINING_CORE_GEODE.get(), block -> this.createSingleItemTable((ItemLike)ModItems.MINING_CORE.get()));
        this.dropSelf((Block)ModBlocks.CURRENCY_MINER.get());
        this.add((Block)ModBlocks.PIGGY_BANK.get(), this.createPiggyBankLootTable((ItemLike)Coin.SPUR.asStack().getItem()));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toList());
    }

    private LootTable.Builder createPiggyBankLootTable(ItemLike coinItem) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.01f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)coinItem)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)250.0f)))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.09f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)coinItem)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)151.0f, (float)249.0f)))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.3f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)coinItem)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)51.0f, (float)150.0f)))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.6f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)coinItem)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)6.0f, (float)50.0f))));
    }
}

