/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator.transform;

import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.sinytra.adapter.patch.util.provider.ZipClassLookup;
import org.sinytra.connector.ConnectorEarlyLoader;
import org.sinytra.connector.locator.ConnectorFabricModMetadata;
import org.sinytra.connector.locator.DependencyResolver;
import org.sinytra.connector.locator.EmbeddedDependencies;
import org.sinytra.connector.locator.transform.EarlyJSCoremodTransformer;
import org.sinytra.connector.service.FabricMixinBootstrap;
import org.sinytra.connector.transformer.TransformerEnvironment;
import org.sinytra.connector.transformer.jar.SimpleClassLookup;
import org.sinytra.connector.transformer.transform.TransformProgressMeter;
import org.sinytra.connector.util.ConnectorUtil;
import org.spongepowered.asm.launch.MixinLaunchPluginLegacy;
import org.spongepowered.asm.service.MixinService;
import reloc.net.minecraftforge.fart.api.ClassProvider;

public class ConnectorTransformerEnvironment
implements TransformerEnvironment {
    private static final Path GENERATED_JAR_PATH = ConnectorUtil.CONNECTOR_FOLDER.resolve("adapter/adapter_generated_mixins.jar");
    private static final Path AUDIT_REPORT_PATH = ConnectorUtil.CONNECTOR_FOLDER.resolve("patch_audit.txt");
    private static final String MAPPED_SUFFIX = "_mapped_moj_" + FMLLoader.versionInfo().mcVersion();
    private static final VarHandle TRANSFORMER_LOADER_FIELD = (VarHandle)LambdaExceptionUtils.uncheck(() -> MethodHandles.privateLookupIn(MixinLaunchPluginLegacy.class, MethodHandles.lookup()).findVarHandle(MixinLaunchPluginLegacy.class, "transformerLoader", ILaunchPluginService.ITransformerLoader.class));
    private final Collection<IModFile> loadedModFiles;

    public ConnectorTransformerEnvironment(Collection<IModFile> loadedModFiles) {
        this.loadedModFiles = loadedModFiles;
    }

    @Override
    public Path getAuditReportPath() {
        return AUDIT_REPORT_PATH;
    }

    @Override
    public Path getGeneratedJarPath() {
        return GENERATED_JAR_PATH;
    }

    @Override
    public ClassLookup getCleanClassLookup() {
        String mcAndNeoFormVersion = FMLLoader.versionInfo().mcAndNeoFormVersion();
        if (FMLEnvironment.production) {
            MavenCoordinate coords = new MavenCoordinate("net.minecraft", FMLEnvironment.dist.isClient() ? "client" : "server", "", "srg", mcAndNeoFormVersion);
            Path path = LibraryFinder.findPathForMaven((MavenCoordinate)coords);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new ModLoadingException(ModLoadingIssue.error((String)"fml.modloadingissue.corrupted_installation", (Object[])new Object[0]).withAffectedPath(path));
            }
            ZipFile zipFile = (ZipFile)LambdaExceptionUtils.uncheck(() -> new ZipFile(path.toFile()));
            return new ZipClassLookup(zipFile);
        }
        Path cleanPath = Optional.ofNullable(System.getProperty("connector.clean.path")).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseThrow(() -> new RuntimeException("Could not determine clean minecraft artifact path"));
        return new SimpleClassLookup(ClassProvider.fromPaths(cleanPath));
    }

    @Override
    public ClassProvider getRuntimeClassProvider(List<Path> libraries) {
        ClassProvider classProvider = ClassProvider.fromPaths((Path[])libraries.toArray(Path[]::new));
        return EarlyJSCoremodTransformer.create(classProvider, this.loadedModFiles);
    }

    @Override
    public LoaderModMetadata wrapModMetadata(LoaderModMetadata metadata) {
        DependencyResolver.removeAliasedModDependencyConstraints(metadata);
        return new ConnectorFabricModMetadata(metadata);
    }

    @Override
    public TransformProgressMeter createProgressMeter(String msg, int steps) {
        return new FMLProgressMeter(StartupNotificationManager.prependProgressBar((String)msg, (int)steps));
    }

    @Override
    public Path createCachedJarPath(String name) throws IOException {
        Files.createDirectories(ConnectorUtil.CONNECTOR_FOLDER, new FileAttribute[0]);
        return ConnectorUtil.CONNECTOR_FOLDER.resolve(name + MAPPED_SUFFIX + ".jar");
    }

    @Override
    public EnvType getEnvType() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    @Override
    public VersionOverrides getVersionOverrides() {
        return DependencyResolver.VERSION_OVERRIDES;
    }

    @Override
    public Supplier<DependencyOverrides> getDependencyOverrides() {
        return DependencyResolver.DEPENDENCY_OVERRIDES;
    }

    @Override
    public void setGlobalBytecodeLoader(@Nullable ILaunchPluginService.ITransformerLoader loader) {
        try {
            MixinLaunchPluginLegacy plugin = (MixinLaunchPluginLegacy)MixinService.getService().getBytecodeProvider();
            TRANSFORMER_LOADER_FIELD.set(plugin, loader);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public RuntimeException onTransformationError(String message, Throwable cause) {
        return new ModLoadingException(ConnectorEarlyLoader.createGenericLoadingIssue(cause, message));
    }

    @Override
    public int getFabricMixinCompatibility(LoaderModMetadata metadata) {
        return FabricMixinBootstrap.MixinConfigDecorator.getMixinCompat(metadata);
    }

    @Override
    public String getJarCacheVersion() {
        return EmbeddedDependencies.getJarCacheVersion();
    }

    private record FMLProgressMeter(ProgressMeter handle) implements TransformProgressMeter
    {
        @Override
        public void increment() {
            this.handle.increment();
        }

        @Override
        public void complete() {
            this.handle.complete();
        }
    }
}

