/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.sinytra.connector.util.ConnectorConfig;
import org.sinytra.connector.util.PriorityModLoadingException;
import org.slf4j.Logger;

public final class MixinTransformSafeguard {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static boolean isEnabled() {
        return ConnectorConfig.INSTANCE.get().enableMixinSafeguard();
    }

    public static void trigger(List<JarTransformer.TransformedFabricModPath> failing) throws ModLoadingException {
        if (!MixinTransformSafeguard.isEnabled()) {
            LOGGER.warn("Ignoring {} found incompatibilities as mixin safeguard is disabled", (Object)failing.size());
            return;
        }
        StartupNotificationManager.addModMessage((String)"INCOMPATIBLE FABRIC MOD FOUND");
        StringBuilder builder = new StringBuilder();
        String msg = "Found \u00a7e" + failing.size() + " incompatible Fabric " + (failing.size() > 1 ? "mods" : "mod") + "\u00a7r. Details are provided below.\n\nWith the current configuration, Connector \u00a7ccannot guarantee\u00a7r a stable environment. Should you still want to proceed, please restart the game.\n\n\u00a77This one-time safety check can be disabled in Connector's config file under \"enableMixinSafeguard\".\u00a7r";
        builder.append(msg).append("\n\n");
        failing.forEach(p -> {
            builder.append("Mod file \u00a7e").append(p.input().getFileName().toString()).append("\u00a7r has failing mixins:\n");
            for (PatchAuditTrail.Candidate failed : p.auditTrail().getFailingMixins()) {
                String[] parts = failed.classNode().name.split("/");
                builder.append("- \u00a7c").append(parts[parts.length - 1]).append("\u00a77#\u00a73").append(failed.methodNode().name).append("\u00a7r\n");
            }
            builder.append("\n");
        });
        throw new PriorityModLoadingException(ModLoadingIssue.error((String)builder.toString(), (Object[])new Object[0]));
    }
}

