/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.locals.LVTSnapshot;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.slf4j.Logger;

public record MoveParametersTransformer(int from, int to) implements ParameterTransformer
{
    static final Codec<MoveParametersTransformer> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.intRange((int)0, (int)255).fieldOf("from").forGetter(MoveParametersTransformer::from), (App)Codec.intRange((int)0, (int)255).fieldOf("to").forGetter(MoveParametersTransformer::to)).apply((Applicative)in, MoveParametersTransformer::new));
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int paramIndex = this.from + offset;
        LOGGER.info(PatchInstance.MIXINPATCH, "Moving parameter from index {} to {} in method {}.{}", new Object[]{this.from, this.to, classNode.name, methodNode.name});
        LocalVariableLookup lookup = new LocalVariableLookup(methodNode);
        LocalVariableNode localVar = lookup.getByParameterOrdinal(paramIndex);
        if (paramIndex < methodNode.parameters.size()) {
            ParameterNode parameter = (ParameterNode)methodNode.parameters.remove(paramIndex);
            methodNode.parameters.add(this.to > paramIndex ? this.to - 1 : this.to, parameter);
        }
        int tempIndex = -999;
        AdapterUtil.replaceLVT(methodNode, idx -> idx == localVar.index ? tempIndex : idx);
        LVTSnapshot.with(methodNode, () -> methodNode.localVariables.remove(localVar));
        parameters.remove(paramIndex);
        Type type = Type.getType((String)localVar.desc);
        localVar.index = lookup.getByParameterOrdinal((int)this.to).index + offset;
        LVTSnapshot.with(methodNode, () -> methodNode.localVariables.add(localVar.index, localVar));
        AdapterUtil.replaceLVT(methodNode, idx -> idx == tempIndex ? localVar.index : idx);
        parameters.add(this.to > paramIndex ? this.to - 1 : this.to, type);
        return Patch.Result.COMPUTE_FRAMES;
    }

    @Override
    public Codec<? extends ParameterTransformer> codec() {
        return CODEC;
    }
}

