/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.mojang.logging.LogUtils;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixArbitraryInjectionPoint;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixAtVariableAssignStore;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixLocalCaptureUpgrade;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixMethodComparison;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixParameterTypeAdapter;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixSliceBoundary;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixSplitMethod;
import org.sinytra.adapter.patch.transformer.dynfix.DynFixSyntheticInstanceof;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.slf4j.Logger;

public class DynamicInjectionPointPatch
implements MethodTransform {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<DynamicFixer<?>> PASSIVE = List.of(new DynFixLocalCaptureUpgrade());
    private static final List<DynamicFixer<?>> FIXES = List.of(new DynFixSliceBoundary(), new DynFixAtVariableAssignStore(), new DynFixSplitMethod(), new DynFixParameterTypeAdapter(), new DynFixMethodComparison(), new DynFixSyntheticInstanceof(), new DynFixArbitraryInjectionPoint());

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        DynamicFixer.FixResult fixResult;
        Object data;
        if (methodContext.findCleanInjectionTarget() == null) {
            return Patch.Result.PASS;
        }
        PatchAuditTrail auditTrail = context.environment().auditTrail();
        Patch.Result result = Patch.Result.PASS;
        for (DynamicFixer<?> fix : PASSIVE) {
            data = fix.prepare(methodContext);
            if (data == null || (fixResult = fix.apply(classNode, methodNode, methodContext, auditTrail, data)) == null) continue;
            auditTrail.recordResult(methodContext, fixResult.match());
            result = result.or(fixResult.result());
        }
        if (methodContext.failsDirtyInjectionCheck()) {
            LOGGER.debug(PatchInstance.MIXINPATCH, "Considering method {}.{}", (Object)classNode.name, (Object)methodNode.name);
            auditTrail.recordResult(methodContext, PatchAuditTrail.Match.NONE);
            for (DynamicFixer<?> fix : FIXES) {
                data = fix.prepare(methodContext);
                if (data == null || (fixResult = fix.apply(classNode, methodNode, methodContext, auditTrail, data)) == null) continue;
                auditTrail.recordResult(methodContext, fixResult.match());
                return result.or(fixResult.result());
            }
        }
        return result;
    }
}

