/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.fixes;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import org.sinytra.adapter.patch.fixes.BytecodeFixerJarGenerator;
import org.sinytra.adapter.patch.fixes.ObjectTypeAdapter;
import org.sinytra.adapter.patch.fixes.SupplierTypeAdapter;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.fixes.TypeAdapterProvider;
import org.sinytra.adapter.patch.util.provider.ClassLookup;

public final class BytecodeFixerUpper {
    public static final List<TypeAdapterProvider> DEFAULT_PROVIDERS = List.of(SupplierTypeAdapter.INSTANCE, ObjectTypeAdapter.INSTANCE);
    private final List<TypeAdapter> fieldTypeAdapters;
    private final List<TypeAdapterProvider> dynamicTypeAdapters;
    private final BytecodeFixerJarGenerator generator;
    private final ClassLookup cleanLookup;
    private final ClassLookup dirtyLookup;
    private final Map<String, Pair<Type, Type>> fieldTypeChangesCache = new ConcurrentHashMap<String, Pair<Type, Type>>();

    public BytecodeFixerUpper(ClassLookup cleanLookup, ClassLookup dirtyLookup, List<TypeAdapter> fieldTypeAdapters) {
        this(cleanLookup, dirtyLookup, fieldTypeAdapters, DEFAULT_PROVIDERS);
    }

    public BytecodeFixerUpper(ClassLookup cleanLookup, ClassLookup dirtyLookup, List<TypeAdapter> fieldTypeAdapters, List<TypeAdapterProvider> dynamicTypeAdapters) {
        this.cleanLookup = cleanLookup;
        this.dirtyLookup = dirtyLookup;
        this.fieldTypeAdapters = fieldTypeAdapters;
        this.dynamicTypeAdapters = dynamicTypeAdapters;
        this.generator = new BytecodeFixerJarGenerator();
    }

    public BytecodeFixerJarGenerator getGenerator() {
        return this.generator;
    }

    public Pair<Type, Type> getFieldTypeChange(String owner, String name) {
        String key = owner + ":" + name;
        return this.fieldTypeChangesCache.computeIfAbsent(key, k -> {
            FieldNode cleanField = this.cleanLookup.findField(owner, name).orElse(null);
            if (cleanField == null) {
                return null;
            }
            FieldNode dirtyField = this.dirtyLookup.findField(owner, name).orElse(null);
            if (dirtyField == null) {
                return null;
            }
            if (!cleanField.desc.equals(dirtyField.desc)) {
                return Pair.of((Object)Type.getType((String)cleanField.desc), (Object)Type.getType((String)dirtyField.desc));
            }
            return null;
        });
    }

    @Nullable
    public TypeAdapter getTypeAdapter(Type from, Type to) {
        for (TypeAdapter typeAdapter : this.fieldTypeAdapters) {
            if (!typeAdapter.from().equals((Object)from) || !typeAdapter.to().equals((Object)to)) continue;
            return typeAdapter;
        }
        for (TypeAdapterProvider dynamicAdapter : this.dynamicTypeAdapters) {
            TypeAdapter adapter = dynamicAdapter.provide(from, to);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }
}

