/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.env.ctx;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ctx.MethodFinder;
import org.sinytra.adapter.next.env.param.MethodParameters;
import org.sinytra.adapter.next.env.param.ParamDiffResolver;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.patch.analysis.params.EnhancedParamsDiff;
import org.sinytra.adapter.patch.analysis.params.LayeredParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.sinytra.adapter.patch.util.MockMixinRuntime;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.refmap.IMixinContext;

public class MethodHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MixinContext context;
    private final MethodFinder methodFinder;
    private final Map<MethodContext.TargetPair, List<AbstractInsnNode>> targetInstructionsCache = new HashMap<MethodContext.TargetPair, List<AbstractInsnNode>>();

    public MethodHelper(MixinContext context, List<Type> targetTypes) {
        this.context = context;
        String singleTargetClass = targetTypes.size() == 1 ? targetTypes.getFirst().getInternalName() : null;
        this.methodFinder = new MethodFinder(singleTargetClass);
    }

    @Nullable
    public MethodNode findMethod(ClassLookup lookup, MethodQualifier qualifier) {
        return Optional.ofNullable(this.findMethodPair(lookup, qualifier)).map(MethodContext.TargetPair::methodNode).orElse(null);
    }

    @Nullable
    public MethodContext.TargetPair findMethodPair(ClassLookup lookup, MethodQualifier qualifier) {
        return this.methodFinder.findMethod(lookup, qualifier, 0);
    }

    @Nullable
    public MethodContext.TargetPair findOwnMethodPair(ClassLookup lookup, MethodQualifier qualifier) {
        return this.methodFinder.findMethod(lookup, qualifier, 2);
    }

    @Nullable
    public Pair<ClassNode, List<MethodNode>> findOwnMethodsByName(ClassLookup lookup, MethodQualifier qualifier) {
        return this.methodFinder.findMethods(lookup, qualifier, 3);
    }

    public List<AbstractInsnNode> findInjectionTargetInsns(@Nullable MethodContext.TargetPair target) {
        return this.targetInstructionsCache.computeIfAbsent(target, this::computeInjectionTargetInsns);
    }

    private List<AbstractInsnNode> computeInjectionTargetInsns(@Nullable MethodContext.TargetPair target) {
        return this.computeInjectionTargetInsns(target, this.context::injectionPointAnnotation, (ctx, h) -> InjectionPoint.parse((IMixinContext)ctx, (MethodNode)this.context.methodNode(), (AnnotationNode)this.context.methodAnnotation().unwrap(), (AnnotationNode)h.unwrap()), true);
    }

    public List<Type> resolveCapturedMethodParams(Configuration clean, Configuration dirty) {
        List<Type> cleanCaptured = clean.getParameters().get(MethodParameters.ParamGroup.CAPTURED_PARAMS);
        List<Type> dirtyCaptured = new ArrayList<Type>();
        if (!cleanCaptured.isEmpty()) {
            MethodNode cleanTarget = this.findMethod(this.context.cleanLookup(), clean.getTargetMethod());
            MethodNode dirtyTarget = this.findMethod(this.context.dirtyLookup(), dirty.getTargetMethod());
            if (cleanTarget == null || dirtyTarget == null) {
                return dirtyCaptured;
            }
            LayeredParamsDiffSnapshot diff = EnhancedParamsDiff.compareMethodParameters(cleanTarget, dirtyTarget);
            List<Type> cleanTargetParams = MethodParameters.getParameterTypes(cleanTarget.desc);
            ParamDiffResolver.ParamEvalResult evalResult = ParamDiffResolver.resolve(cleanTargetParams, diff);
            int maxIndex = cleanCaptured.stream().map(evalResult::getUpdated).filter(Objects::nonNull).mapToInt(ParamDiffResolver.ParamState::dirtyIndex).max().orElse(-1);
            if (maxIndex != -1) {
                List<Type> dirtyTargetParams = MethodParameters.getParameterTypes(dirtyTarget.desc);
                dirtyCaptured = List.copyOf(dirtyTargetParams.subList(0, maxIndex + 1));
            }
        }
        return dirtyCaptured;
    }

    @Nullable
    private List<AbstractInsnNode> computeInjectionTargetInsns(@Nullable MethodContext.TargetPair target, Supplier<AnnotationHandle> atNodeSupplier, BiFunction<IMixinContext, AnnotationHandle, InjectionPoint> injectionPointParser, boolean ignoreShift) {
        if (target == null) {
            return List.of();
        }
        AnnotationHandle atNode = atNodeSupplier.get();
        if (atNode == null) {
            return List.of();
        }
        AnnotationHandle atNodeCopy = atNode.copy();
        if (ignoreShift) {
            atNodeCopy.removeValues("shift");
        }
        PatchContext patchContext = this.context.patchContext();
        IMixinContext mixinContext = MockMixinRuntime.forClass(this.context.classNode().name, target.classNode().name, patchContext.environment());
        InjectionPoint injectionPoint = injectionPointParser.apply(mixinContext, atNodeCopy);
        Target mixinTarget = MockMixinRuntime.createMixinTarget(target);
        InsnList instructions = this.getSlicedInsns(this.context.methodAnnotation(), this.context.classNode(), this.context.methodNode(), target.classNode(), target.methodNode(), patchContext, mixinTarget);
        ArrayList<AbstractInsnNode> targetInsns = new ArrayList<AbstractInsnNode>();
        try {
            if (MockMixinRuntime.injectionPointNeedsSpecialCare(injectionPoint)) {
                MockMixinRuntime.findModifyVariableInjectionInsns(injectionPoint, mixinContext, target.methodNode().instructions, targetInsns, mixinTarget);
            } else {
                injectionPoint.find(target.methodNode().desc, instructions, targetInsns);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error finding injection insns", e);
            return List.of();
        }
        return targetInsns;
    }

    private InsnList getSlicedInsns(AnnotationHandle parentAnnotation, ClassNode classNode, MethodNode injectorMethod, ClassNode targetClass, MethodNode targetMethod, PatchContext context, Target mixinTarget) {
        return parentAnnotation.getValue("slice").map(handle -> {
            AnnotationNode annotationNode;
            Object value = handle.get();
            if (value instanceof List) {
                List list = (List)value;
                annotationNode = (AnnotationNode)list.getFirst();
            } else {
                annotationNode = (AnnotationNode)value;
            }
            return annotationNode;
        }).map(sliceAnn -> {
            IMixinContext mixinContext = MockMixinRuntime.forClass(classNode.name, targetClass.name, context.environment());
            ISliceContext sliceContext = MockMixinRuntime.forSlice(mixinContext, injectorMethod);
            return this.computeSlicedInsns(sliceContext, (AnnotationNode)sliceAnn, mixinTarget);
        }).orElse(targetMethod.instructions);
    }

    private InsnList computeSlicedInsns(ISliceContext context, AnnotationNode annotation, Target mixinTarget) {
        MethodSlice slice = MethodSlice.parse((ISliceContext)context, (AnnotationNode)annotation);
        return slice.getSlice(mixinTarget);
    }

    public static boolean isStatic(MethodNode node) {
        return (node.access & 8) != 0;
    }
}

