/*
 * Decompiled with CFR 0.152.
 */
package guideme.layout.flow;

import guideme.document.LytRect;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowSpan;
import guideme.layout.LayoutContext;
import guideme.layout.flow.Line;
import guideme.layout.flow.LineBlock;
import guideme.layout.flow.LineBuilder;
import guideme.layout.flow.LineElement;
import guideme.render.RenderContext;
import guideme.style.TextAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;

public class FlowBuilder {
    private final List<Line> lines = new ArrayList<Line>();
    private final List<LytFlowContent> rootContent = new ArrayList<LytFlowContent>();
    private final List<LineBlock> floats = new ArrayList<LineBlock>();

    public void append(LytFlowContent content) {
        this.rootContent.add(content);
    }

    public LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth, TextAlignment alignment) {
        this.lines.clear();
        this.floats.clear();
        LineBuilder lineBuilder = new LineBuilder(context, x, y, availableWidth, this.lines, this.floats, alignment);
        for (LytFlowContent content : this.rootContent) {
            this.visitInDocumentOrder(content, lineBuilder);
        }
        lineBuilder.end();
        return lineBuilder.getBounds();
    }

    public void renderBatch(RenderContext context, MultiBufferSource buffers, @Nullable LytFlowContent hoveredContent) {
        for (Line line : this.lines) {
            LineElement el = line.firstElement();
            while (el != null) {
                el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
                el.renderBatch(context, buffers);
                el = el.next;
            }
        }
    }

    public void renderFloatsBatch(RenderContext context, MultiBufferSource buffers, @Nullable LytFlowContent hoveredContent) {
        for (LineBlock el : this.floats) {
            el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
            el.renderBatch(context, buffers);
        }
    }

    public void render(RenderContext context, @Nullable LytFlowContent hoveredContent) {
        for (Line line : this.lines) {
            LineElement el = line.firstElement();
            while (el != null) {
                el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
                el.render(context);
                el = el.next;
            }
        }
    }

    public void renderFloats(RenderContext context, @Nullable LytFlowContent hoveredContent) {
        for (LineBlock el : this.floats) {
            el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
            el.render(context);
        }
    }

    private void visitInDocumentOrder(LytFlowContent content, Consumer<LytFlowContent> visitor) {
        if (content instanceof LytFlowSpan) {
            LytFlowSpan flowSpan = (LytFlowSpan)content;
            for (LytFlowContent child : flowSpan.getChildren()) {
                this.visitInDocumentOrder(child, visitor);
            }
        } else {
            visitor.accept(content);
        }
    }

    @Nullable
    public LineElement pick(int x, int y) {
        LineBlock floatEl = this.pickFloatingElement(x, y);
        if (floatEl != null) {
            return floatEl;
        }
        for (Line line : this.lines) {
            if (!line.bounds().contains(x, y)) continue;
            LineElement el = line.firstElement();
            while (el != null) {
                if (el.bounds.contains(x, y)) {
                    return el;
                }
                el = el.next;
            }
        }
        return null;
    }

    public Stream<LytRect> enumerateContentBounds(LytFlowContent content) {
        return Stream.concat(this.lines.stream().flatMap(Line::elements), this.floats.stream()).filter(el -> el.getFlowContent() == content).map(el -> el.bounds);
    }

    @Nullable
    public LineBlock pickFloatingElement(int x, int y) {
        for (LineBlock el : this.floats) {
            if (!el.bounds.contains(x, y)) continue;
            return el;
        }
        return null;
    }

    public boolean floatsIntersect(LytRect bounds) {
        for (LineBlock el : this.floats) {
            if (!el.bounds.intersects(bounds)) continue;
            return true;
        }
        return false;
    }

    public Iterable<LytFlowContent> getContent() {
        return this.rootContent;
    }

    public boolean isEmpty() {
        return this.rootContent.isEmpty();
    }

    public void clear() {
        this.lines.clear();
        this.rootContent.clear();
        this.floats.clear();
    }

    public void move(int deltaX, int deltaY) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            this.lines.set(i, new Line(line.bounds().move(deltaX, deltaY), line.firstElement()));
            LineElement el = line.firstElement();
            while (el != null) {
                el.bounds = el.bounds.move(deltaX, deltaY);
                if (el instanceof LineBlock) {
                    LineBlock lineBlock = (LineBlock)el;
                    lineBlock.getBlock().setLayoutPos(lineBlock.getBlock().getBounds().point().add(deltaX, deltaY));
                }
                el = el.next;
            }
        }
    }
}

