/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.search.AutomatonQuery;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.AutomatonProvider;
import guideme.internal.shaded.lucene.util.automaton.Operations;
import guideme.internal.shaded.lucene.util.automaton.RegExp;

public class RegexpQuery
extends AutomatonQuery {
    public static final AutomatonProvider DEFAULT_PROVIDER = name -> null;

    public RegexpQuery(Term term) {
        this(term, 255);
    }

    public RegexpQuery(Term term, int flags) {
        this(term, flags, DEFAULT_PROVIDER, 10000);
    }

    public RegexpQuery(Term term, int flags, int determinizeWorkLimit) {
        this(term, flags, DEFAULT_PROVIDER, determinizeWorkLimit);
    }

    public RegexpQuery(Term term, int syntaxFlags, int matchFlags, int determinizeWorkLimit) {
        this(term, syntaxFlags, matchFlags, DEFAULT_PROVIDER, determinizeWorkLimit, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public RegexpQuery(Term term, int syntaxFlags, AutomatonProvider provider, int determinizeWorkLimit) {
        this(term, syntaxFlags, 0, provider, determinizeWorkLimit, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public RegexpQuery(Term term, int syntaxFlags, int matchFlags, AutomatonProvider provider, int determinizeWorkLimit, MultiTermQuery.RewriteMethod rewriteMethod) {
        this(term, syntaxFlags, matchFlags, provider, determinizeWorkLimit, rewriteMethod, true);
    }

    public RegexpQuery(Term term, int syntaxFlags, int matchFlags, AutomatonProvider provider, int determinizeWorkLimit, MultiTermQuery.RewriteMethod rewriteMethod, boolean doDeterminization) {
        super(term, RegexpQuery.toAutomaton(new RegExp(term.text(), syntaxFlags, matchFlags), determinizeWorkLimit, provider, doDeterminization), false, rewriteMethod);
    }

    private static Automaton toAutomaton(RegExp regexp, int determinizeWorkLimit, AutomatonProvider provider, boolean doDeterminization) {
        if (doDeterminization) {
            return Operations.determinize(regexp.toAutomaton(provider), determinizeWorkLimit);
        }
        return regexp.toAutomaton(provider);
    }

    public Term getRegexp() {
        return this.term;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append('/');
        buffer.append(this.term.text());
        buffer.append('/');
        return buffer.toString();
    }
}

