/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.queries.intervals.Intervals;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Locale;

public class Wildcard
extends IntervalFunction {
    private final String wildcard;
    private final int maxExpansions;

    public Wildcard(String wildcard, int maxExpansions) {
        this.wildcard = wildcard;
        this.maxExpansions = maxExpansions;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        if (this.maxExpansions == 0) {
            return Intervals.wildcard(new BytesRef(this.wildcard));
        }
        return Intervals.wildcard(new BytesRef(this.wildcard), this.maxExpansions);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:wildcard(%s%s)", this.wildcard, this.maxExpansions == 0 ? "" : " maxExpansions:" + this.maxExpansions);
    }
}

