/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.codecs.KnnFieldVectorsWriter;
import guideme.internal.shaded.lucene.codecs.KnnVectorsFormat;
import guideme.internal.shaded.lucene.codecs.KnnVectorsWriter;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.SegmentInfo;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.InfoStream;
import java.io.IOException;

class VectorValuesConsumer {
    private final Codec codec;
    private final Directory directory;
    private final SegmentInfo segmentInfo;
    private final InfoStream infoStream;
    private Accountable accountable = Accountable.NULL_ACCOUNTABLE;
    private KnnVectorsWriter writer;

    VectorValuesConsumer(Codec codec, Directory directory, SegmentInfo segmentInfo, InfoStream infoStream) {
        this.codec = codec;
        this.directory = directory;
        this.segmentInfo = segmentInfo;
        this.infoStream = infoStream;
    }

    private void initKnnVectorsWriter(String fieldName) throws IOException {
        if (this.writer == null) {
            KnnVectorsFormat fmt = this.codec.knnVectorsFormat();
            if (fmt == null) {
                throw new IllegalStateException("field=\"" + fieldName + "\" was indexed as vectors but codec does not support vectors");
            }
            SegmentWriteState initialWriteState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, null, null, IOContext.DEFAULT);
            this.writer = fmt.fieldsWriter(initialWriteState);
            this.accountable = this.writer;
        }
    }

    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        this.initKnnVectorsWriter(fieldInfo.name);
        return this.writer.addField(fieldInfo);
    }

    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush(state.segmentInfo.maxDoc(), sortMap);
            this.writer.finish();
        }
        catch (Throwable throwable) {
            IOUtils.close(this.writer);
            throw throwable;
        }
        IOUtils.close(this.writer);
    }

    void abort() {
        IOUtils.closeWhileHandlingException(this.writer);
    }

    public Accountable getAccountable() {
        return this.accountable;
    }
}

