/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.LatLonShapeBoundingBoxQuery;
import guideme.internal.shaded.lucene.document.LatLonShapeDocValues;
import guideme.internal.shaded.lucene.document.LatLonShapeDocValuesField;
import guideme.internal.shaded.lucene.document.LatLonShapeDocValuesQuery;
import guideme.internal.shaded.lucene.document.LatLonShapeQuery;
import guideme.internal.shaded.lucene.document.ShapeField;
import guideme.internal.shaded.lucene.geo.Circle;
import guideme.internal.shaded.lucene.geo.GeoEncodingUtils;
import guideme.internal.shaded.lucene.geo.LatLonGeometry;
import guideme.internal.shaded.lucene.geo.Line;
import guideme.internal.shaded.lucene.geo.Point;
import guideme.internal.shaded.lucene.geo.Polygon;
import guideme.internal.shaded.lucene.geo.Rectangle;
import guideme.internal.shaded.lucene.geo.Tessellator;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.ArrayList;
import java.util.List;

public class LatLonShape {
    private LatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        return LatLonShape.createIndexableFields(fieldName, polygon, false);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Polygon polygon) {
        return LatLonShape.createDocValueField(fieldName, polygon, false);
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        Field[] fields = new ShapeField.Triangle[tessellation.size()];
        for (int i = 0; i < tessellation.size(); ++i) {
            fields[i] = new ShapeField.Triangle(fieldName, tessellation.get(i));
        }
        return fields;
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Polygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(tessellation.size());
        for (Tessellator.Triangle t : tessellation) {
            ShapeField.DecodedTriangle dt = new ShapeField.DecodedTriangle();
            dt.type = ShapeField.DecodedTriangle.TYPE.TRIANGLE;
            dt.setValues(t.getEncodedX(0), t.getEncodedY(0), t.isEdgefromPolygon(0), t.getEncodedX(1), t.getEncodedY(1), t.isEdgefromPolygon(0), t.getEncodedX(2), t.getEncodedY(2), t.isEdgefromPolygon(2));
            triangles.add(dt);
        }
        return new LatLonShapeDocValuesField(fieldName, triangles);
    }

    public static Field[] createIndexableFields(String fieldName, Line line) {
        int numPoints = line.numPoints();
        Field[] fields = new Field[numPoints - 1];
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            fields[i] = new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), GeoEncodingUtils.encodeLongitude(line.getLon(j)), GeoEncodingUtils.encodeLatitude(line.getLat(j)), GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)));
            ++i;
        }
        return fields;
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Line line) {
        int numPoints = line.numPoints();
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(numPoints - 1);
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            ShapeField.DecodedTriangle t = new ShapeField.DecodedTriangle();
            t.type = ShapeField.DecodedTriangle.TYPE.LINE;
            t.setValues(GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), true, GeoEncodingUtils.encodeLongitude(line.getLon(j)), GeoEncodingUtils.encodeLatitude(line.getLat(j)), true, GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), true);
            triangles.add(t);
            ++i;
        }
        return new LatLonShapeDocValuesField(fieldName, triangles);
    }

    public static Field[] createIndexableFields(String fieldName, double lat, double lon) {
        return new Field[]{new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat))};
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, double lat, double lon) {
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(1);
        ShapeField.DecodedTriangle t = new ShapeField.DecodedTriangle();
        t.type = ShapeField.DecodedTriangle.TYPE.POINT;
        t.setValues(GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), true, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), true, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), true);
        triangles.add(t);
        return new LatLonShapeDocValuesField(fieldName, triangles);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, BytesRef binaryValue) {
        return new LatLonShapeDocValuesField(fieldName, binaryValue);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, List<ShapeField.DecodedTriangle> tessellation) {
        return new LatLonShapeDocValuesField(fieldName, tessellation);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Field[] indexableFields) {
        ArrayList<ShapeField.DecodedTriangle> tess = new ArrayList<ShapeField.DecodedTriangle>(indexableFields.length);
        byte[] scratch = new byte[28];
        for (Field f : indexableFields) {
            BytesRef br = f.binaryValue();
            assert (br.length == 28);
            System.arraycopy(br.bytes, br.offset, scratch, 0, 28);
            ShapeField.DecodedTriangle t = new ShapeField.DecodedTriangle();
            ShapeField.decodeTriangle(scratch, t);
            tess.add(t);
        }
        return new LatLonShapeDocValuesField(fieldName, tess);
    }

    public static Query newBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS && minLongitude > maxLongitude) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, 180.0), BooleanClause.Occur.MUST);
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, -180.0, maxLongitude), BooleanClause.Occur.MUST);
            return builder.build();
        }
        Rectangle rectangle = new Rectangle(minLatitude, maxLatitude, minLongitude, maxLongitude);
        return new LatLonShapeBoundingBoxQuery(field, queryRelation, rectangle);
    }

    public static Query newSlowDocValuesBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS && minLongitude > maxLongitude) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, 180.0), BooleanClause.Occur.MUST);
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, -180.0, maxLongitude), BooleanClause.Occur.MUST);
            return builder.build();
        }
        return new LatLonShapeDocValuesQuery(field, queryRelation, new Rectangle(minLatitude, maxLatitude, minLongitude, maxLongitude));
    }

    public static Query newLineQuery(String field, ShapeField.QueryRelation queryRelation, Line ... lines) {
        return LatLonShape.newGeometryQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, ShapeField.QueryRelation queryRelation, Polygon ... polygons) {
        return LatLonShape.newGeometryQuery(field, queryRelation, polygons);
    }

    public static Query newPointQuery(String field, ShapeField.QueryRelation queryRelation, double[] ... points) {
        LatLonGeometry[] pointArray = new Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointArray[i] = new Point(points[i][0], points[i][1]);
        }
        return LatLonShape.newGeometryQuery(field, queryRelation, pointArray);
    }

    public static Query newDistanceQuery(String field, ShapeField.QueryRelation queryRelation, Circle ... circle) {
        return LatLonShape.newGeometryQuery(field, queryRelation, circle);
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... latLonGeometries) {
        if (latLonGeometries.length == 1) {
            LatLonGeometry geometry = latLonGeometries[0];
            if (geometry instanceof Rectangle) {
                Rectangle rect = (Rectangle)geometry;
                return LatLonShape.newBoxQuery(field, queryRelation, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
            }
            return new LatLonShapeQuery(field, queryRelation, latLonGeometries);
        }
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            return LatLonShape.makeContainsGeometryQuery(field, latLonGeometries);
        }
        return new LatLonShapeQuery(field, queryRelation, latLonGeometries);
    }

    public static LatLonShapeDocValues createLatLonShapeDocValues(BytesRef bytesRef) {
        return new LatLonShapeDocValues(bytesRef);
    }

    private static Query makeContainsGeometryQuery(String field, LatLonGeometry ... latLonGeometries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (LatLonGeometry geometry : latLonGeometries) {
            if (geometry instanceof Rectangle) {
                Rectangle rect = (Rectangle)geometry;
                builder.add(LatLonShape.newBoxQuery(field, ShapeField.QueryRelation.CONTAINS, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon), BooleanClause.Occur.MUST);
                continue;
            }
            builder.add(new LatLonShapeQuery(field, ShapeField.QueryRelation.CONTAINS, geometry), BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery(builder.build());
    }
}

