/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.en;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.en.KStemmer;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class KStemFilter
extends TokenFilter {
    private final KStemmer stemmer = new KStemmer();
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);

    public KStemFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] term = this.termAttribute.buffer();
        int len = this.termAttribute.length();
        if (!this.keywordAtt.isKeyword() && this.stemmer.stem(term, len)) {
            this.termAttribute.setEmpty().append(this.stemmer.asCharSequence());
        }
        return true;
    }
}

