/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;

public class EntityEffectPredicateParser {
    public static Component parseEntityEffectPredicate(MobEffectsPredicate predicate) {
        Map effects = predicate.effectMap();
        LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
        for (Map.Entry entry : effects.entrySet()) {
            Optional visible;
            Optional ambient;
            MinMaxBounds.Ints duration;
            Component name = ((MobEffect)((Holder)entry.getKey()).value()).getDisplayName();
            MobEffectsPredicate.MobEffectInstancePredicate data = (MobEffectsPredicate.MobEffectInstancePredicate)entry.getValue();
            MinMaxBounds.Ints amplifier = data.amplifier();
            if (!amplifier.equals((Object)MinMaxBounds.Ints.ANY)) {
                Optional max;
                Optional min = amplifier.min();
                if (Objects.equals(min, max = amplifier.max()) && min.isPresent()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier", name, (Integer)min.get() + 1));
                } else if (min.isPresent() && max.isPresent()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier_2", name, (Integer)min.get() + 1, (Integer)max.get() + 1));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier_3", name));
                }
            }
            if (!(duration = data.duration()).equals((Object)MinMaxBounds.Ints.ANY)) {
                Optional max;
                Optional min = duration.min();
                if (Objects.equals(min, max = duration.max()) && min.isPresent()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration", name, (Integer)min.get() + 1));
                } else if (min.isPresent() && max.isPresent()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration_2", name, (Integer)min.get() + 1, (Integer)max.get() + 1));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration_3", name));
                }
            }
            if ((ambient = data.ambient()).isPresent()) {
                if (((Boolean)ambient.get()).booleanValue()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.ambient_true", name));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.ambient_false", name));
                }
            }
            if ((visible = data.visible()).isPresent()) {
                if (((Boolean)visible.get()).booleanValue()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.visible_true", name));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.visible_false", name));
                }
            }
            list.add(LText.translatable("emi_loot.entity_predicate.effect.fallback", name));
        }
        if (!list.isEmpty()) {
            return LText.translatable("emi_loot.entity_predicate.effect_1", ListProcessors.buildAndList(list));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Unparsable entity effect predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

