/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface LootReceiver {
    public boolean isEmpty();

    public ResourceLocation getId();

    public LootReceiver fromBuf(FriendlyByteBuf var1);

    default public ItemStack readItemStack(FriendlyByteBuf buf) {
        Holder byId = BuiltInRegistries.ITEM.wrapAsHolder((Object)((Item)BuiltInRegistries.ITEM.byId(buf.readVarInt())));
        int count = buf.readVarInt();
        if (buf.readBoolean()) {
            CompoundTag nbt = buf.readNbt();
            DataResult changesResult = DataComponentPatch.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt);
            DataComponentPatch changes = (DataComponentPatch)changesResult.mapOrElse(Function.identity(), err -> DataComponentPatch.EMPTY);
            if (changes.isEmpty()) {
                return new ItemStack(byId, count);
            }
            return new ItemStack(byId, count, changes);
        }
        return new ItemStack(byId, count);
    }
}

