/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.model;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WeightedBakedModel.class})
public class WeightedBakedModelMixin {
    @Shadow
    @Final
    private List<WeightedEntry.Wrapper<BakedModel>> list;
    @Shadow
    @Final
    private int totalWeight;

    @Unique
    private static <T extends WeightedEntry> T getAt(List<T> pool, int totalWeight) {
        WeightedEntry weighted;
        int i = 0;
        int len = pool.size();
        do {
            if (i < len) continue;
            return null;
        } while ((totalWeight -= (weighted = (WeightedEntry)pool.get(i++)).getWeight().asInt()) >= 0);
        return (T)weighted;
    }

    @Overwrite
    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction face, RandomSource random, ModelData modelData, @Nullable RenderType renderType) {
        WeightedEntry.Wrapper<BakedModel> quad = WeightedBakedModelMixin.getAt(this.list, Math.abs((int)random.nextLong()) % this.totalWeight);
        if (quad != null) {
            return ((BakedModel)quad.data()).getQuads(state, face, random, modelData, renderType);
        }
        return Collections.emptyList();
    }

    @Overwrite
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        WeightedEntry.Wrapper<BakedModel> quad = WeightedBakedModelMixin.getAt(this.list, Math.abs((int)rand.nextLong()) % this.totalWeight);
        if (quad != null) {
            return ((BakedModel)quad.data()).getRenderTypes(state, rand, data);
        }
        return ChunkRenderTypeSet.none();
    }
}

