/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.create;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={IHaveGoggleInformation.class}, remap=false)
public interface MixinIHaveGoggleInformation {
    @Overwrite
    default public boolean containedFluidTooltip(List<Component> tooltip, boolean isPlayerSneaking, IFluidHandler handler) {
        if (handler == null) {
            return false;
        }
        if (handler.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack fluidStack = handler.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            if ((WaterPurity.hasPurity(fluidStack) || fluidStack.getFluid().equals(Fluids.WATER)) && WaterPurity.getPurity(fluidStack) != -1) {
                int purity = WaterPurity.getPurity(fluidStack);
                ChatFormatting color = this.getPurityColor(purity);
                CreateLang.builder().text(WaterPurity.getPurityText(purity) + " ").add(fluidStack.getHoverName().copy()).style(color).forGoggles(tooltip, 1);
            } else {
                CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            }
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)handler.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (handler.getTanks() > 1) {
            if (isEmpty) {
                tooltip.removeLast();
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)handler.getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        return true;
    }

    default public ChatFormatting getPurityColor(int purity) {
        if (purity == 3) {
            return ChatFormatting.AQUA;
        }
        if (purity == 2) {
            return ChatFormatting.BLUE;
        }
        if (purity == 1) {
            return ChatFormatting.GRAY;
        }
        if (purity == 0) {
            return ChatFormatting.DARK_GRAY;
        }
        return ChatFormatting.GRAY;
    }
}

