/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin;

import dev.ghen.thirst.content.thirst.PlayerThirst;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModAttachment;
import dev.ghen.thirst.foundation.config.CommonConfig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public abstract class MixinFoodData {
    @Shadow
    private float exhaustionLevel;
    @Unique
    private int dehydratedHealTimer = 0;

    @Shadow
    public abstract void addExhaustion(float var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;heal(F)V", ordinal=0))
    private void healWithSaturation(Player player, float amount) {
        boolean shouldHeal;
        FoodData foodData = player.getFoodData();
        IThirst thirstData = (IThirst)player.getData(ModAttachment.PLAYER_THIRST);
        float f = Math.min(foodData.getSaturationLevel(), 6.0f);
        boolean bl = shouldHeal = (Boolean)CommonConfig.DEHYDRATION_HALTS_HEALTH_REGEN.get() == false || thirstData.getThirst() >= 20;
        if (shouldHeal) {
            player.heal(f / 6.0f);
            thirstData.setJustHealed();
            return;
        }
        ++this.dehydratedHealTimer;
        if (this.dehydratedHealTimer >= 8 && thirstData.getThirst() > 18) {
            player.heal(f / 6.0f);
            thirstData.setJustHealed();
            this.dehydratedHealTimer = 0;
            return;
        }
        this.addExhaustion(-f);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;heal(F)V", ordinal=1))
    private void healWithHunger(Player player, float amount) {
        boolean shouldHeal;
        IThirst thirstData = (IThirst)player.getData(ModAttachment.PLAYER_THIRST);
        boolean bl = shouldHeal = (Boolean)CommonConfig.DEHYDRATION_HALTS_HEALTH_REGEN.get() == false || thirstData.getThirst() > 18;
        if (shouldHeal) {
            player.heal(1.0f);
            thirstData.setJustHealed();
        } else {
            this.addExhaustion(-6.0f);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void DealWithExhaustionBySaturation(Player player, CallbackInfo ci) {
        if (this.exhaustionLevel > 4.0f) {
            ((PlayerThirst)player.getData(ModAttachment.PLAYER_THIRST)).ExhaustionRecalculate();
        }
    }
}

