/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin;

import dev.ghen.thirst.content.purity.WaterPurity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={FluidUtil.class}, remap=false)
public class MixinFluidUtil {
    @Overwrite
    @NotNull
    public static ItemStack getFilledBucket(@NotNull FluidStack fluidStack) {
        if (fluidStack.getComponents().isEmpty()) {
            if (fluidStack.is((Fluid)Fluids.WATER)) {
                return new ItemStack((ItemLike)Items.WATER_BUCKET);
            }
            if (fluidStack.is((Fluid)Fluids.LAVA)) {
                return new ItemStack((ItemLike)Items.LAVA_BUCKET);
            }
        }
        if (WaterPurity.hasPurity(fluidStack)) {
            return WaterPurity.addPurity(new ItemStack((ItemLike)fluidStack.getFluid().getBucket()), (int)WaterPurity.getPurity(fluidStack));
        }
        return new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
    }
}

