/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.config;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    private static final ModConfigSpec SPEC;
    public static final ModConfigSpec.Builder BUILDER;
    public static final ModConfigSpec.ConfigValue<Boolean> ONLY_SHOW_PURITY_WHEN_SHIFTING;
    public static final ModConfigSpec.ConfigValue<Integer> THIRST_BAR_Y_OFFSET;
    public static final ModConfigSpec.ConfigValue<Integer> THIRST_BAR_X_OFFSET;
    public static final ModConfigSpec.ConfigValue<Boolean> DRINK_BOTH_HAND_NEEDED;

    public static void setup(ModContainer modContainer) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path configFolder = Paths.get(configPath.toAbsolutePath().toString(), "thirst");
        try {
            Files.createDirectory(configFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "thirst/client.toml");
    }

    static {
        BUILDER = new ModConfigSpec.Builder();
        BUILDER.push("Purity tooltip");
        ONLY_SHOW_PURITY_WHEN_SHIFTING = BUILDER.comment("If the purity tooltip should be shown only when the player is pressing the shift key").define("onlyShowPurityWhenShifting", false);
        BUILDER.pop();
        BUILDER.push("Thirst Bar");
        THIRST_BAR_Y_OFFSET = BUILDER.comment("How many pixels should the thirst bar be shifted vertically from its original position").define("thirstBarYOffset", (Object)0);
        THIRST_BAR_X_OFFSET = BUILDER.comment("How many pixels should the thirst bar be shifted horizontally from its original position").define("thirstBarXOffset", (Object)0);
        BUILDER.pop();
        BUILDER.push("Client Drink Mechanics");
        DRINK_BOTH_HAND_NEEDED = BUILDER.comment("Whether players needs two hands available to drink water from source").define("DrinkBothHandNeeded", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

