/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;

public class Selectors {
    private static Map<String, Rarity> rarities = new HashMap<String, Rarity>(){
        {
            this.put("common", Rarity.COMMON);
            this.put("uncommon", Rarity.UNCOMMON);
            this.put("rare", Rarity.RARE);
            this.put("epic", Rarity.EPIC);
        }
    };
    private static Map<String, BiPredicate<Tag, String>> nbtComparators = new HashMap<String, BiPredicate<Tag, String>>(){
        {
            this.put("=", (tag, value) -> tag.getAsString().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.getAsString().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumericTag) {
                        return ((NumericTag)tag).getAsDouble() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumericTag) {
                        return ((NumericTag)tag).getAsDouble() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static List<SelectorDocumentation> selectorDocumentation() {
        return Arrays.asList(new SelectorDocumentation("Match all", "Specifying just an asterisk (*) will match all items.", "*"), new SelectorDocumentation("Item ID", "Use item ID to match single items.  Must include mod name for modded items.", "minecraft:stick", "iron_ore", "spoiledeggs:spoiled_egg"), new SelectorDocumentation("Tag", "$ followed by tag name to match all items with that tag.", "$forge:stone", "$planks"), new SelectorDocumentation("Mod name", "@ followed by mod identifier to match all items from that mod.", "@spoiledeggs"), new SelectorDocumentation("Rarity", "! followed by item's rarity to match all items with that rarity.  This is ONLY vanilla rarities.", "!uncommon", "!rare", "!epic"), new SelectorDocumentation("Item name color", "# followed by color hex code, to match all items with that exact color item name.", "#23F632"), new SelectorDocumentation("Display name", "% followed by any text.  Will match any item with this text (case-sensitive) in its tooltip display name.", "%Netherite", "%Uncommon"), new SelectorDocumentation("Tooltip text", "^ followed by any text.  Will match any item with this text (case-sensitive) anywhere in the tooltip text (besides the name).", "^Legendary"), new SelectorDocumentation("NBT/Item component", "& followed by tag or component name and optional comparator (=, >, <, or !=) and value, in the format <name><comparator><value> or just <name>.", "&damage>100", "&Tier>1", "&map_id!=128", "&enchantments"), new SelectorDocumentation("Negation", "~ followed by any selector above.  This selector will be negated, matching every item that does NOT match the selector.", "~minecraft:stick", "~!uncommon", "~@minecraft"), new SelectorDocumentation("Combining selectors", "Any number of selectors can be combined by separating them with a plus sign.", "minecraft:diamond_sword+&enchantments", "minecraft:stick+~!common+&damage>100"));
    }

    public static boolean validateSelector(String value) {
        if (value.contains("+")) {
            for (String selector : value.split("\\+")) {
                if (Selectors.validateSelector(selector)) continue;
                return false;
            }
            return true;
        }
        if (value.startsWith("~")) {
            return Selectors.validateSelector(value.substring(1));
        }
        if (value.contentEquals("*")) {
            return true;
        }
        if (value.startsWith("$")) {
            return ResourceLocation.tryParse((String)value.substring(1)) != null;
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return TextColor.parseColor((String)value).result().orElse(null) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || ResourceLocation.tryParse((String)value) != null;
    }

    public static boolean itemMatches(ItemStack item, String selector, HolderLookup.Provider provider) {
        if (item.isEmpty()) {
            return false;
        }
        if (selector.contains("+")) {
            for (String subSelector : selector.split("\\+")) {
                if (Selectors.itemMatches(item, subSelector, provider)) continue;
                return false;
            }
            return true;
        }
        if (selector.startsWith("~")) {
            return !Selectors.itemMatches(item, selector.substring(1), provider);
        }
        if (selector.contentEquals("*")) {
            return true;
        }
        String itemResourceLocation = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("#")) {
            TextColor entryColor = TextColor.parseColor((String)selector).result().orElse(null);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, TextColor.fromRgb((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.getRarity() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            Optional<TagKey> matchingTag = BuiltInRegistries.ITEM.getTagNames().filter(tagKey -> tagKey.location().equals((Object)ResourceLocation.parse((String)selector.substring(1)))).findFirst();
            if (matchingTag.isPresent() && item.is(matchingTag.get())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.getDisplayName().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            Minecraft mc = Minecraft.getInstance();
            List lines = item.getTooltipLines(Item.TooltipContext.EMPTY, (Player)mc.player, (TooltipFlag)TooltipFlag.Default.ADVANCED);
            Object tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = (String)tooltipText + ((Component)lines.get(n)).getString() + "\n";
            }
            if (((String)tooltipText).contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            Tag itemTag;
            boolean result;
            CharSequence[] components;
            Object name = selector.substring(1);
            Object value = null;
            BiPredicate<Tag, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!((String)name).contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                components = ((String)name).split(comparator);
                name = components[0];
                if (components.length <= 1) break;
                value = components[1];
                break;
            }
            if (!(result = Selectors.findMatchingSubtag(itemTag = item.save(provider), (String)name, value, valueChecker))) {
                if (!((String)name).contains(":")) {
                    name = "minecraft:" + (String)name;
                }
                if (value != null) {
                    if (!((String)value).contains(":") && ((String)value).matches("^[a-z]+$")) {
                        value = "minecraft:" + (String)value;
                    } else if (((String)value).contains("\"")) {
                        components = ((String)value).split("\"");
                        for (int i = 0; i < components.length; ++i) {
                            if (i % 2 != 1 || ((String)components[i]).contains(":")) continue;
                            components[i] = "minecraft:" + (String)components[i];
                        }
                        value = String.join((CharSequence)"\"", components);
                    }
                }
                result = Selectors.findMatchingSubtag(itemTag, (String)name, (String)value, valueChecker);
            }
            return result;
        }
        return false;
    }

    private static boolean findMatchingSubtag(Tag tag, String key, String value, BiPredicate<Tag, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.getId() == 8) {
            try {
                tag = TagParser.parseTag((String)tag.getAsString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tag.getId() == 10) {
            CompoundTag compoundTag = (CompoundTag)tag;
            if (compoundTag.contains(key)) {
                if (value == null && valueChecker == null) {
                    return true;
                }
                return valueChecker.test(compoundTag.get(key), value);
            }
            for (String innerKey : compoundTag.getAllKeys()) {
                if (compoundTag.getTagType(innerKey) == 9 || compoundTag.getTagType(innerKey) == 10) {
                    if (!Selectors.findMatchingSubtag(compoundTag.get(innerKey), key, value, valueChecker)) continue;
                    return true;
                }
                if (compoundTag.getTagType(innerKey) != 8) continue;
                try {
                    tag = TagParser.parseTag((String)tag.getAsString());
                    if (!Selectors.findMatchingSubtag(compoundTag.get(innerKey), key, value, valueChecker)) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }
        if (tag.getId() == 9) {
            ListTag listTag = (ListTag)tag;
            for (Tag innerTag : listTag) {
                if (innerTag.getId() != 9 && innerTag.getId() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker)) continue;
                return true;
            }
        }
        return false;
    }

    public record SelectorDocumentation(String name, String description, List<String> examples) {
        public SelectorDocumentation(String name, String description, String ... examples) {
            this(name, description, Arrays.asList(examples));
        }
    }
}

