/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.mixins.entity.misc;

import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.player.ETFPlayerEntity;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends Entity
implements ETFPlayerEntity {
    public MixinPlayerEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract Inventory getInventory();

    @Shadow
    @NotNull
    public abstract Component getName();

    @Shadow
    public abstract boolean isModelPartShown(PlayerModelPart var1);

    @Inject(method={"interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")})
    private void etf$injected(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.level().isClientSide() && ETF.config().getConfig().debugLoggingMode != ETFConfig.DebugLogMode.None) {
            ETFManager.getInstance().markEntityForDebugPrint(entity.getUUID());
        }
    }

    @Override
    public Entity etf$getEntity() {
        return this;
    }

    @Override
    public boolean etf$isTeammate(Player player) {
        return this.isAlliedTo((Entity)player);
    }

    @Override
    public Inventory etf$getInventory() {
        return this.getInventory();
    }

    @Override
    @Deprecated
    public boolean etf$isPartVisible(PlayerModelPart part) {
        return this.isModelPartShown(part);
    }

    @Override
    public Component etf$getName() {
        return this.getName();
    }

    @Override
    public String etf$getUuidAsString() {
        return this.getStringUUID();
    }
}

