/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockUtils {
    public static void translateBlock(BlockState blockState, PoseStack poseStack) {
        poseStack.translate(0.5f, 0.5f, 0.5f);
        float direction = BlockUtils.getYRotation(blockState);
        poseStack.mulPose(Axis.YP.rotationDegrees(direction));
        if (blockState.hasProperty((Property)BlockStateProperties.ATTACH_FACE)) {
            AttachFace face = (AttachFace)blockState.getValue((Property)BlockStateProperties.ATTACH_FACE);
            switch (face) {
                case CEILING: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    break;
                }
                case WALL: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                }
            }
        }
        poseStack.translate(0.0f, -0.5f, 0.0f);
    }

    public static float getYRotation(BlockState blockState) {
        if (blockState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            return 22.5f * (float)((Integer)blockState.getValue((Property)BlockStateProperties.ROTATION_16)).intValue();
        }
        if (blockState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return -((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot();
        }
        if (blockState.hasProperty((Property)DirectionalBlock.FACING)) {
            return -((Direction)blockState.getValue((Property)DirectionalBlock.FACING)).toYRot();
        }
        return 0.0f;
    }
}

