/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.registry;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class DeferredObject<T>
implements Supplier<T> {
    private final ResourceKey<?> key;
    private Holder<?> holder = null;

    public DeferredObject(ResourceKey<?> key) {
        this.key = key;
        this.bind(false);
    }

    @Override
    public T get() {
        this.bind(true);
        if (this.holder == null) {
            throw new NullPointerException("Trying to access unbound value: " + String.valueOf(this.key));
        }
        return (T)this.holder.value();
    }

    public final <R> void bind(boolean throwOnMissingRegistry) {
        if (this.holder != null) {
            return;
        }
        Registry<?> registry = this.getRegistry();
        if (registry != null) {
            this.holder = registry.getHolder(this.key).orElse(null);
        } else if (throwOnMissingRegistry) {
            throw new IllegalStateException("Registry not present for " + String.valueOf(this) + ": " + String.valueOf(this.key.registry()));
        }
    }

    public ResourceKey<?> getKey() {
        return this.key;
    }

    public ResourceKey<? extends Registry<?>> getRegistryKey() {
        return this.key.registryKey();
    }

    public Registry<?> getRegistry() {
        return (Registry)BuiltInRegistries.REGISTRY.get(this.getKey().registry());
    }

    public ResourceLocation getId() {
        return this.getKey().location();
    }

    public boolean isBound() {
        this.bind(false);
        return this.holder != null && this.holder.isBound();
    }
}

