/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.config.holders;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pandamods.pandalib.config.Config;
import me.pandamods.pandalib.config.ConfigData;
import me.pandamods.pandalib.config.holders.ConfigHolder;
import net.minecraft.world.entity.player.Player;

public class ClientConfigHolder<T extends ConfigData>
extends ConfigHolder<T> {
    private final Map<UUID, T> configs = new HashMap<UUID, T>();

    public ClientConfigHolder(Class<T> configClass, Config config) {
        super(configClass, config);
    }

    @Override
    public void save() {
        if (Platform.getEnvironment().equals((Object)Env.CLIENT)) {
            super.save();
        } else {
            this.logger.warn("Client config '{}' can't be saved on server", (Object)this.getDefinition().name());
        }
    }

    @Override
    public boolean load() {
        if (Platform.getEnvironment().equals((Object)Env.CLIENT)) {
            return super.load();
        }
        return false;
    }

    public <C extends ConfigData> void putConfig(Player player, C config) {
        this.configs.put(player.getUUID(), config);
    }

    public T getConfig(Player player) {
        if (this.configs.containsKey(player.getUUID())) {
            return (T)((ConfigData)this.configs.get(player.getUUID()));
        }
        return this.get();
    }
}

