/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

class DirectionalCakeConversion
implements BlockUse {
    DirectionalCakeConversion() {
    }

    @Override
    public boolean altersWorld() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.DIRECTIONAL_CAKE.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return block == Blocks.CAKE || block.builtInRegistryHolder().is(BlockTags.CANDLE_CAKES) && Utils.getID((Block)block).getNamespace().equals("minecraft");
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (state.is(BlockTags.CANDLE_CAKES) && stack.is(ItemTags.CANDLES)) {
            return InteractionResult.PASS;
        }
        if (state.is(Blocks.CAKE) && (stack.is(ItemTags.CANDLES) || player.getDirection() == Direction.EAST || (Integer)state.getValue((Property)CakeBlock.BITES) != 0)) {
            return InteractionResult.PASS;
        }
        if (!CommonConfigs.DOUBLE_CAKES.get().booleanValue() || !stack.is(Items.CAKE)) {
            BlockState newState = ModRegistry.DIRECTIONAL_CAKE.get().defaultBlockState();
            if (world.isClientSide) {
                world.setBlock(pos, newState, 3);
            }
            BlockHitResult raytrace = new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), hit.getDirection(), pos, false);
            InteractionResult r = newState.useWithoutItem(world, player, raytrace);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                if (r.consumesAction()) {
                    Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null).forEach(d -> {
                        if (d.getItem() != Items.CAKE) {
                            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)d);
                        }
                    });
                    state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
                } else {
                    world.setBlock(pos, state, 3);
                }
            }
            return r;
        }
        return InteractionResult.PASS;
    }
}

