/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.CarpetSlabBlock;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CarpetedBlockTile
extends MimicBlockTile {
    private static final Map<Pair<SoundType, SoundType>, SoundType> MIXED_SOUND_MAP = new HashMap<Pair<SoundType, SoundType>, SoundType>();
    public static final ModelDataKey<BlockState> CARPET_KEY = new ModelDataKey(BlockState.class);
    private BlockState carpet = Blocks.WHITE_CARPET.defaultBlockState();
    private SoundType soundType = null;

    public CarpetedBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.CARPET_STAIRS_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(CARPET_KEY, (Object)this.carpet);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        HolderLookup.RegistryLookup holderGetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        this.setCarpet(NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)tag.getCompound("Carpet")));
    }

    public void setCarpet(BlockState carpet) {
        this.setHeldBlock(carpet, 1);
    }

    public BlockState getCarpet() {
        return this.getHeldBlock(1);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Carpet", (Tag)NbtUtils.writeBlockState((BlockState)this.carpet));
    }

    public BlockState getHeldBlock(int index) {
        if (index == 1) {
            return this.carpet;
        }
        return super.getHeldBlock(index);
    }

    public boolean setHeldBlock(BlockState state, int index) {
        if (index == 0) {
            this.mimic = state;
        } else if (index == 1) {
            this.carpet = state;
        }
        this.soundType = null;
        if (this.level instanceof ServerLevel) {
            this.setChanged();
            int newLight = Math.max(ForgeHelper.getLightEmission((BlockState)this.getCarpet(), (Level)this.level, (BlockPos)this.worldPosition), ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(), (Level)this.level, (BlockPos)this.worldPosition));
            this.level.setBlock(this.worldPosition, (BlockState)((BlockState)this.getBlockState().setValue((Property)ModBlockProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight))).setValue((Property)CarpetSlabBlock.SOLID, (Comparable)Boolean.valueOf(this.getHeldBlock().canOcclude())), 3);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        } else {
            this.requestModelReload();
        }
        return true;
    }

    public void initialize(BlockState stairs, BlockState carpet) {
        this.setHeldBlock(carpet, 1);
        this.setHeldBlock(stairs, 0);
    }

    @Nullable
    public SoundType getSoundType() {
        if (this.soundType == null) {
            BlockState stairs = this.getHeldBlock();
            BlockState carpet = this.getHeldBlock(1);
            if (!stairs.isAir() && !carpet.isAir()) {
                SoundType stairsSound = stairs.getSoundType();
                SoundType carpetSound = carpet.getSoundType();
                this.soundType = MIXED_SOUND_MAP.computeIfAbsent((Pair<SoundType, SoundType>)Pair.of((Object)stairsSound, (Object)carpetSound), p -> new SoundType(1.0f, 1.0f, stairsSound.getBreakSound(), carpetSound.getStepSound(), stairsSound.getPlaceSound(), stairsSound.getHitSound(), carpetSound.getFallSound()));
            } else {
                return null;
            }
        }
        return this.soundType;
    }
}

