/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.WaterloggedLilyBlockTile;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WaterloggedLilyBlock
extends WaterlilyBlock
implements LiquidBlockContainer,
EntityBlock {
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape AABB_EXTENDED = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)17.5, (double)15.0);
    protected static final VoxelShape AABB_FAKE = Block.box((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)17.5, (double)15.0);
    protected static final VoxelShape AABB_SUPPORT = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;

    public WaterloggedLilyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{EXTENDED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.getValue((Property)EXTENDED) != false ? AABB_FAKE : AABB;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)EXTENDED) != false ? AABB_EXTENDED : AABB;
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return AABB_SUPPORT;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public FluidState getFluidState(BlockState state) {
        return Fluids.WATER.getSource(false);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        return stateIn;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, world, pos, neighborBlock, fromPos, moving);
        if (pos.above().equals((Object)fromPos)) {
            this.maybeConvertToVanilla(state, (LevelAccessor)world, pos);
        }
    }

    public void tick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (!this.maybeConvertToVanilla(state, (LevelAccessor)serverLevel, pos)) {
            // empty if block
        }
        super.tick(state, serverLevel, pos, random);
    }

    private boolean maybeConvertToVanilla(BlockState state, LevelAccessor serverLevel, BlockPos pos) {
        Object object;
        if (serverLevel.getBlockState(pos.above()).isAir() && (object = serverLevel.getBlockEntity(pos)) instanceof WaterloggedLilyBlockTile) {
            WaterloggedLilyBlockTile te = (WaterloggedLilyBlockTile)((Object)object);
            serverLevel.setBlock(pos, Blocks.WATER.defaultBlockState(), 3);
            serverLevel.setBlock(pos.above(), te.getHeldBlock(), 3);
            for (Entity e : serverLevel.getEntitiesOfClass(Entity.class, AABB_SUPPORT.bounds().move(pos).move(0.0, 0.0625, 0.0))) {
                if (e.getPistonPushReaction() == PushReaction.IGNORE) continue;
                e.move(MoverType.SHULKER_BOX, new Vec3(0.0, 0.09375, 0.0));
            }
            return true;
        }
        if (((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
            serverLevel.setBlock(pos, (BlockState)state.setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)), 3);
        }
        return false;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public long getSeed(BlockState pState, BlockPos pPos) {
        return Mth.getSeed((Vec3i)pPos.above());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WaterloggedLilyBlockTile(pos, state);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).isAir() && !(mimicState.getBlock() instanceof WaterloggedLilyBlock)) {
            return Math.min(super.getDestroyProgress(state, player, worldIn, pos), mimicState.getDestroyProgress(player, worldIn, pos));
        }
        return super.getDestroyProgress(state, player, worldIn, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).isAir()) {
            return mimicState.getSoundType();
        }
        return super.getSoundType(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            BlockState heldState = tile.getHeldBlock();
            Object object2 = builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (!ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.getLevel(), (BlockPos)BlockPos.containing((Position)((Position)builder.getParameter(LootContextParams.ORIGIN))), (ServerPlayer)player)) {
                    return drops;
                }
            }
            List newDrops = heldState.getDrops(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).isAir() && !(mimicState.getBlock() instanceof WaterloggedLilyBlock)) {
            return Math.max(ForgeHelper.getExplosionResistance((BlockState)mimicState, (Level)((Level)world), (BlockPos)pos, (Explosion)explosion), state.getBlock().getExplosionResistance());
        }
        return 2.0f;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public String getDescriptionId() {
        return Blocks.LILY_PAD.getDescriptionId();
    }
}

