/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonSpecialItemRenderer;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CandleHolderRendererExtension
implements IThirdPersonAnimationProvider,
IThirdPersonSpecialItemRenderer,
IFirstPersonSpecialItemRenderer {
    private static final ResourceLocation FLAME_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/particle/flame.png");
    private static final ResourceLocation SOUL_FLAME_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/particle/soul_fire_flame.png");
    private static final ResourceLocation ENDER_FLAME_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"endergetic", (String)"textures/particle/ender_fire_flame.png");
    private static final ResourceLocation CUPRIC_FLAME_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caverns_and_chasms", (String)"textures/particle/cupric_fire_flame.png");
    private static final ResourceLocation REDSTONE_FLAME_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/particle/generic_6.png");
    private final BlockState offState;
    private final BlockState litState;
    private final Vec3 candleParticleOffset;
    private final ResourceLocation flameTexture;

    public CandleHolderRendererExtension(BlockItem blockItem) {
        this.offState = blockItem.getBlock().defaultBlockState();
        this.litState = (BlockState)this.offState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
        this.candleParticleOffset = SuppCompat.getCandleHolderParticleOffset(this.offState);
        ResourceLocation id = Utils.getID((Item)blockItem);
        String path = id.getPath();
        this.flameTexture = path.endsWith("soul") || path.startsWith("soul") ? SOUL_FLAME_TEXTURE : (path.endsWith("ender") || path.startsWith("ender") ? ENDER_FLAME_TEXTURE : (path.endsWith("cupric") || path.startsWith("cupric") ? CUPRIC_FLAME_TEXTURE : (path.endsWith("redstone") || path.startsWith("redstone") ? REDSTONE_FLAME_TEXTURE : FLAME_TEXTURE)));
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack itemStack, HumanoidModel<T> model, T t, HumanoidArm arm) {
        model.rightArm.xRot = (float)(-Math.toRadians(40.0));
        return true;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack itemStack, HumanoidModel<T> model, T t, HumanoidArm arm) {
        model.leftArm.xRot = (float)(-Math.toRadians(40.0));
        return true;
    }

    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            ((ArmedModel)parentModel).translateToHand(humanoidArm, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            boolean left = humanoidArm == HumanoidArm.LEFT;
            poseStack.translate((float)(left ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            poseStack.scale(2.0f, 2.0f, 2.0f);
            ItemTransform transform = new ItemTransform(new Vector3f(55.0f, -180.0f, 0.0f), new Vector3f(0.0f, 2.0f, 1.25f).mul(0.0625f), new Vector3f(0.375f, 0.375f, 0.375f));
            transform.apply(left, poseStack);
            this.renderBlockModel(entity, stack, poseStack, bufferSource, light, left);
            if (!entity.isInWater()) {
                this.renderFlame(entity, poseStack, bufferSource, stack);
            }
            poseStack.popPose();
        }
    }

    private void renderFlame(LivingEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, ItemStack stack) {
        VertexConsumer builder = bufferSource.getBuffer(RenderType.text((ResourceLocation)this.flameTexture));
        int lu = 240;
        int lv = 240;
        int b = 255;
        int g = 255;
        int r = 255;
        int a = 255;
        float period = 20.0f;
        float t = ((float)entity.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)) % period / period;
        float ss = 1.0f - t * t * 0.4f;
        float scale = ss * 2.0f / 16.0f;
        Matrix4f mat = new Matrix4f();
        Quaternionf cameraRot = Minecraft.getInstance().gameRenderer.getMainCamera().rotation();
        poseStack.translate(this.candleParticleOffset.x, this.candleParticleOffset.y, this.candleParticleOffset.z);
        mat.setTranslation((Vector3fc)poseStack.last().pose().getTranslation(new Vector3f()));
        mat.rotate((Quaternionfc)cameraRot);
        poseStack.last().pose().set((Matrix4fc)mat);
        poseStack.scale(-scale, scale, -scale);
        VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (int)r, (int)g, (int)b, (int)a, (int)lu, (int)lv);
    }

    private void renderBlockModel(LivingEntity entity, ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int light, boolean left) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        BlockState state = entity.isInWater() ? this.offState : this.litState;
        BakedModel model = mc.getBlockRenderer().getBlockModel(state);
        itemRenderer.render(itemStack, ItemDisplayContext.NONE, left, poseStack, buffer, light, OverlayTexture.NO_OVERLAY, model);
    }

    public boolean renderFirstPersonItem(AbstractClientPlayer player, ItemStack stack, InteractionHand interactionHand, HumanoidArm arm, PoseStack poseStack, float partialTicks, float pitch, float attackAnim, float equipAnim, MultiBufferSource buffer, int light, ItemInHandRenderer renderer) {
        boolean left = arm == HumanoidArm.LEFT;
        float f = left ? -1.0f : 1.0f;
        poseStack.pushPose();
        float n = -0.4f * Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI));
        float m = 0.2f * Mth.sin((float)(Mth.sqrt((float)attackAnim) * ((float)Math.PI * 2)));
        float h = -0.2f * Mth.sin((float)(attackAnim * (float)Math.PI));
        poseStack.translate(f * n, m, h);
        renderer.applyItemArmTransform(poseStack, arm, equipAnim);
        renderer.applyItemArmAttackTransform(poseStack, arm, attackAnim);
        poseStack.translate(0.0, 0.3125, 0.0);
        float scale = (float)ClientConfigs.CANDLE_HOLDING_SIZE.get().doubleValue();
        poseStack.scale(-scale, scale, -scale);
        this.renderBlockModel((LivingEntity)player, stack, poseStack, buffer, light, left);
        if (!player.isInWater()) {
            poseStack.translate((double)f * 0.03, 0.0, (double)-0.04f);
            this.renderFlame((LivingEntity)player, poseStack, buffer, stack);
        }
        poseStack.popPose();
        return true;
    }
}

