/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.buttons.MenuButton;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonOptionsScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import journeymap.client.ui.UIManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class MainConfigScreen
extends SeasonHudScreen {
    private static final Component SCREEN_TITLE = Common.translatedText("menu.seasonhud.main.title");
    private static final Component MINIMAP_SETTINGS = Common.translatedText("menu.seasonhud.main.minimap.options");
    private static final Component JOURNEYMAP = Common.translatedText("menu.seasonhud.main.journeymap.title");
    private final List<AbstractWidget> optionButtons = new ArrayList<AbstractWidget>();
    MenuButton seasonButton;
    MenuButton colorButton;
    CycleButton<Boolean> enableMinimapIntegrationButton;
    CycleButton<Boolean> showMinimapHiddenButton;
    Button journeyMapButton;
    private boolean enableMod;
    private boolean showMinimapHidden;
    private boolean enableMinimapIntegration;

    public MainConfigScreen() {
        super(null, SCREEN_TITLE);
        this.loadConfig();
        this.BUTTON_WIDTH = 170;
    }

    public static MainConfigScreen getInstance() {
        return new MainConfigScreen();
    }

    public void loadConfig() {
        this.enableMod = SeasonHudClient.getEnableMod();
        this.showMinimapHidden = SeasonHudClient.getShowDefaultWhenMinimapHidden();
        this.enableMinimapIntegration = SeasonHudClient.getEnableMinimapIntegration();
    }

    @Override
    public void saveConfig() {
        SeasonHudClient.setEnableMod(this.enableMod);
        SeasonHudClient.setEnableMinimapIntegration(this.enableMinimapIntegration);
        SeasonHudClient.setShowDefaultWhenMinimapHidden(this.showMinimapHidden);
        SeasonHudClient.CLIENT_SPEC.save();
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void onClose() {
        super.onClose();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, MINIMAP_SETTINGS, n, 50 + 2 * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            int n2 = this.width / 2;
            Objects.requireNonNull(this.font);
            graphics.drawCenteredString(this.font, JOURNEYMAP, n2, 50 + 4 * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
            this.journeyMapButton.active = this.enableMod;
        }
        this.seasonButton.active = this.enableMod;
        this.colorButton.active = this.enableMod;
        this.enableMinimapIntegrationButton.active = this.enableMod;
        this.showMinimapHiddenButton.active = this.enableMod;
    }

    @Override
    public void init() {
        super.init();
        int enableModWidth = this.font.width((FormattedText)Common.translatedText("menu.seasonhud.main.enableMod.button").append(": OFF")) + 8;
        CycleButton enableModButton = CycleButton.onOffBuilder((boolean)this.enableMod).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.enableMod.tooltip")).create(this.width - enableModWidth - 5, 5, enableModWidth, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.enableMod.button"), (b, val) -> {
            this.enableMod = val;
        });
        int row = 0;
        this.seasonButton = MenuButton.builder(MenuButton.MenuButtons.SEASON, b -> {
            this.saveConfig();
            SeasonOptionsScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.season.tooltip")).withPos(this.leftButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        this.colorButton = MenuButton.builder(MenuButton.MenuButtons.COLORS, b -> {
            this.saveConfig();
            ColorScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.color.tooltip")).withPos(this.rightButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        row = 2;
        this.enableMinimapIntegrationButton = CycleButton.onOffBuilder((boolean)this.enableMinimapIntegration).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.minimapIntegration.tooltip")).create(this.leftButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.enableMinimapIntegration.button"), (b, val) -> {
            this.enableMinimapIntegration = val;
        });
        this.showMinimapHiddenButton = CycleButton.onOffBuilder((boolean)this.showMinimapHidden).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.showMinimapHidden.tooltip")).create(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.showMinimapHidden.button"), (b, val) -> {
            this.showMinimapHidden = val;
        });
        this.widgets.addAll(Arrays.asList(new AbstractButton[]{this.seasonButton, this.colorButton, enableModButton, this.enableMinimapIntegrationButton, this.showMinimapHiddenButton}));
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            this.journeyMapButton = Button.builder((Component)Common.translatedText("menu.seasonhud.main.journeymap.options.button"), button -> UIManager.INSTANCE.openAddonOptionsEditor((Screen)this, true)).tooltip(Tooltip.create((Component)Common.translatedText("menu.seasonhud.main.journeymap.options.tooltip"))).bounds(this.leftButtonX, this.buttonStartY + (row += 2) * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT).build();
            this.addRenderableWidget((GuiEventListener)this.journeyMapButton);
        }
        this.widgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }
}

