/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.lantern;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.fluids.tank.ConfigurableFluidTank;
import plus.dragons.createdragonsplus.common.fluids.tank.FluidTankBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.fluids.lantern.ExperienceLanternBlock;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public class ExperienceLanternBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected FluidTankBehaviour tank;
    protected AABB effectiveAABB = new AABB(this.getBlockPos()).inflate(0.5);
    protected int rate;

    public ExperienceLanternBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.rate = (Integer)CEIConfig.fluids().experienceLanternDrainRate.get();
    }

    protected ConfigurableFluidTank createTank(Consumer<FluidStack> fluidUpdateCallback) {
        return new ConfigurableFluidTank(((Integer)CEIConfig.fluids().experienceLanternFluidCapacity.get()).intValue(), fluidUpdateCallback.andThen(this::onFluidStackChanged)).allowInsertion(fluidStack -> fluidStack.is(CEIFluids.EXPERIENCE));
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.level.getGameTime() % 10L == 0L) {
            this.drainExp();
        }
        if (!this.level.isClientSide && ((Boolean)CEIConfig.fluids().experienceLanternPullToggle.get()).booleanValue()) {
            this.pullExp();
        }
    }

    public FluidTankBehaviour getTank() {
        return this.tank;
    }

    protected void drainExp() {
        List experienceOrbs;
        List players = this.level.getEntitiesOfClass(Player.class, this.effectiveAABB, player -> player.isAlive() && !player.isSpectator());
        if (!players.isEmpty()) {
            int inserted;
            AtomicInteger sum = new AtomicInteger();
            players.forEach(player -> {
                int playerExp = ExperienceHelper.getExperienceForPlayer(player);
                if (playerExp >= this.rate) {
                    sum.addAndGet(this.rate);
                } else if (playerExp != 0) {
                    sum.addAndGet(playerExp);
                }
            });
            if (sum.get() != 0 && (inserted = this.tank.getPrimaryHandler().fill(new FluidStack(CEIFluids.EXPERIENCE, sum.get()), IFluidHandler.FluidAction.EXECUTE)) != 0) {
                for (Player player2 : players) {
                    int total = ExperienceHelper.getExperienceForPlayer(player2);
                    if (inserted >= this.rate) {
                        if (total >= this.rate) {
                            player2.giveExperiencePoints(-this.rate);
                            inserted -= this.rate;
                            continue;
                        }
                        if (total == 0) continue;
                        inserted -= total;
                        player2.giveExperiencePoints(-total);
                        continue;
                    }
                    if (inserted <= 0) break;
                    if (total >= inserted) {
                        player2.giveExperiencePoints(-inserted);
                        inserted = 0;
                        continue;
                    }
                    inserted -= total;
                    player2.giveExperiencePoints(-total);
                }
            }
        }
        if (!(experienceOrbs = this.level.getEntitiesOfClass(ExperienceOrb.class, this.effectiveAABB)).isEmpty()) {
            for (ExperienceOrb orb : experienceOrbs) {
                int amount = orb.value;
                FluidStack fluidStack = new FluidStack((Fluid)CEIFluids.EXPERIENCE.get(), amount);
                int inserted = this.tank.getPrimaryHandler().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (inserted == amount) {
                    orb.remove(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                if (inserted == 0) break;
                orb.value -= inserted;
                break;
            }
        }
    }

    protected void pullExp() {
        List experienceOrbs = this.level.getEntitiesOfClass(ExperienceOrb.class, this.effectiveAABB.inflate((double)((Integer)CEIConfig.fluids().experienceLanternPullRadius.get()).intValue()));
        if (!experienceOrbs.isEmpty()) {
            for (ExperienceOrb orb : experienceOrbs) {
                if (!(orb.getDeltaMovement().length() <= 0.5)) continue;
                double pushForce = (Double)CEIConfig.fluids().experienceLanternPullForceMultiplier.get() * 1.0 / orb.position().distanceTo(this.getBlockPos().getCenter());
                Vec3 directionToLantern = this.getBlockPos().getCenter().subtract(orb.position()).normalize().multiply(pushForce, pushForce, pushForce);
                orb.push(directionToLantern);
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new FluidTankBehaviour((SmartBlockEntity)this, this::createTank);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        int light = (int)((float)this.tank.getPrimaryTank().tank.getFluid().getAmount() / (float)this.tank.getPrimaryTank().tank.getCapacity() * 15.0f);
        light = Math.min(Math.max(0, light), 15);
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ExperienceLanternBlock.LIGHT, (Comparable)Integer.valueOf(light)));
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (side == null || side.getOpposite() == this.getBlockState().getValue((Property)DirectionalBlock.FACING)) {
            return this.tank.getCapability();
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, null));
    }
}

