/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.List;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.VerticalTreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VerticalTree
implements TreeType {
    @Override
    public boolean isTreeStem(BlockState blockState) {
        return this.getConfig().filter.isValid(blockState);
    }

    @Override
    public TreeData gatherTreeData(BlockPos blockPos, Level level, Player player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.getMainHandItem())) {
            return null;
        }
        blockPos = blockPos.immutable();
        TreeData.Builder builder = TreeData.builder();
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        this.gatherBlocks(level, blockPos, blocks);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos block : blocks) {
                BlockState blockState = level.getBlockState(block);
                List items = Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)block, null, (Entity)player, (ItemStack)player.getMainHandItem());
                drops.addAll(items);
            }
        }
        return builder.addBlocks(blocks).setToolDamage(blocks.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)blocks.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)blocks.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(blocks.stream().map(logPos -> {
            BlockState blockState = level.getBlockState(logPos);
            return Stats.BLOCK_MINED.get((Object)blockState.getBlock());
        }).toList()).build();
    }

    private void gatherBlocks(Level level, BlockPos blockPos, List<BlockPos> blocks) {
        BlockState blockState = level.getBlockState(blockPos);
        blocks.add(blockPos);
        BlockPos neighborPos = blockPos.above();
        if (level.getBlockState(neighborPos).is(blockState.getBlock())) {
            this.gatherBlocks(level, neighborPos, blocks);
        }
    }

    public VerticalTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.verticalTree;
    }
}

