/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.mixin;

import me.pandamods.fallingtrees.compat.Compat;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class MultiPlayerGameModeMixin {
    @Shadow
    private BlockPos destroyBlockPos;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private boolean fallingTrees$lastTickCrouchState = false;
    @Unique
    private Direction fallingTrees$blockDestroyDirection = Direction.UP;

    @Shadow
    public abstract boolean isDestroying();

    @Inject(method={"startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="RETURN")})
    public void startDestroyBlock(BlockPos loc, Direction face, CallbackInfoReturnable<Boolean> cir) {
        this.fallingTrees$blockDestroyDirection = face;
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        Level level;
        BlockState blockState;
        if (FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.disable || Compat.hasTreeChop()) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        if (player != null && TreeRegistry.getTree(blockState = (level = player.level()).getBlockState(this.destroyBlockPos)) != null) {
            if (player.isCrouching() != this.fallingTrees$lastTickCrouchState && this.isDestroying() && this.minecraft.gameMode != null) {
                MultiPlayerGameMode gameMode = this.minecraft.gameMode;
                gameMode.stopDestroyBlock();
                gameMode.startDestroyBlock(this.destroyBlockPos, this.fallingTrees$blockDestroyDirection);
            }
            this.fallingTrees$lastTickCrouchState = player.isCrouching();
        }
    }
}

