/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.mixin;

import java.util.Optional;
import me.pandamods.fallingtrees.api.TreeHandler;
import me.pandamods.fallingtrees.compat.Compat;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public class BlockBehaviourMixin {
    @Inject(method={"getDestroyProgress(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos, CallbackInfoReturnable<Float> cir) {
        if (FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.disable || Compat.hasTreeChop()) {
            return;
        }
        if (player == null || !TreeHandler.canPlayerChopTree(player)) {
            return;
        }
        Optional<Float> miningSpeedOpt = TreeHandler.getMiningSpeed(player, pos, ((Float)cir.getReturnValue()).floatValue());
        miningSpeedOpt.ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }
}

